/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.TableStatsProvider;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.statistics.TableStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public class CachingTableStatsProvider
implements TableStatsProvider {
    private final Metadata metadata;
    private final Session session;
    private final Map<TableHandle, TableStatistics> cache = new WeakHashMap<TableHandle, TableStatistics>();

    public CachingTableStatsProvider(Metadata metadata, Session session) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public TableStatistics getTableStatistics(TableHandle tableHandle) {
        TableStatistics stats = this.cache.get(tableHandle);
        if (stats == null) {
            stats = this.metadata.getTableStatistics(this.session, tableHandle);
            this.cache.put(tableHandle, stats);
        }
        return stats;
    }

    public Map<TableHandle, TableStatistics> getCachedTableStatistics() {
        return ImmutableMap.copyOf(this.cache);
    }
}

