/*
 * Decompiled with CFR 0.152.
 */
package io.trino.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.trino.exchange.DirectExchangeInput;
import io.trino.exchange.ExchangeDataSource;
import io.trino.exchange.ExchangeInput;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.OperatorInfo;
import java.net.URI;
import java.util.Objects;

public class DirectExchangeDataSource
implements ExchangeDataSource {
    private final DirectExchangeClient directExchangeClient;

    public DirectExchangeDataSource(DirectExchangeClient directExchangeClient) {
        this.directExchangeClient = Objects.requireNonNull(directExchangeClient, "directExchangeClient is null");
    }

    @Override
    public Slice pollPage() {
        return this.directExchangeClient.pollPage();
    }

    @Override
    public boolean isFinished() {
        return this.directExchangeClient.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        return this.directExchangeClient.isBlocked();
    }

    @Override
    public void addInput(ExchangeInput input) {
        DirectExchangeInput exchangeInput = (DirectExchangeInput)input;
        this.directExchangeClient.addLocation(exchangeInput.getTaskId(), URI.create(exchangeInput.getLocation()));
    }

    @Override
    public void noMoreInputs() {
        this.directExchangeClient.noMoreLocations();
    }

    @Override
    public OperatorInfo getInfo() {
        return this.directExchangeClient.getStatus();
    }

    @Override
    public void close() {
        this.directExchangeClient.close();
    }
}

