/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class CreateRoleTask
implements DataDefinitionTask<CreateRole> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public CreateRoleTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "CREATE ROLE";
    }

    @Override
    public ListenableFuture<Void> execute(CreateRole statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        Optional<String> catalog = MetadataUtil.processRoleCommandCatalog(this.metadata, session, (Node)statement, statement.getCatalog().map(Identifier::getValue));
        String role = statement.getName().getValue().toLowerCase(Locale.ENGLISH);
        Optional<TrinoPrincipal> grantor = statement.getGrantor().map(specification -> MetadataUtil.createPrincipal(session, specification));
        this.accessControl.checkCanCreateRole(session.toSecurityContext(), role, grantor, catalog);
        if (this.metadata.roleExists(session, role, catalog)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_ALREADY_EXISTS, (Node)statement, "Role '%s' already exists", role);
        }
        grantor.ifPresent(trinoPrincipal -> MetadataUtil.checkRoleExists(session, (Node)statement, this.metadata, trinoPrincipal, catalog));
        this.metadata.createRole(session, role, grantor, catalog);
        return Futures.immediateVoidFuture();
    }
}

