/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.operator.OperatorStats;
import io.trino.spi.metrics.Distribution;
import io.trino.spi.metrics.Metric;
import io.trino.spi.metrics.Metrics;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@JsonSerialize
public record DistributionSnapshot(long total, double min, double max, double p01, double p05, double p10, double p25, double p50, double p75, double p90, double p95, double p99) implements Metric<DistributionSnapshot>
{
    public DistributionSnapshot(Distribution<?> distribution) {
        this(distribution.getTotal(), distribution.getMin(), distribution.getMax(), distribution.getPercentile(0.01), distribution.getPercentile(0.05), distribution.getPercentile(0.1), distribution.getPercentile(0.25), distribution.getPercentile(0.5), distribution.getPercentile(0.75), distribution.getPercentile(0.9), distribution.getPercentile(0.95), distribution.getPercentile(0.99));
    }

    public static List<OperatorStats> pruneOperatorStats(List<OperatorStats> operatorStats) {
        Objects.requireNonNull(operatorStats, "operatorStats is null");
        return (List)operatorStats.stream().map(DistributionSnapshot::pruneOperatorStats).collect(ImmutableList.toImmutableList());
    }

    public static OperatorStats pruneOperatorStats(OperatorStats operatorStats) {
        Objects.requireNonNull(operatorStats, "operatorStats is null");
        return new OperatorStats(operatorStats.getStageId(), operatorStats.getPipelineId(), operatorStats.getOperatorId(), operatorStats.getPlanNodeId(), operatorStats.getOperatorType(), operatorStats.getTotalDrivers(), operatorStats.getAddInputCalls(), operatorStats.getAddInputWall(), operatorStats.getAddInputCpu(), operatorStats.getPhysicalInputDataSize(), operatorStats.getPhysicalInputPositions(), operatorStats.getPhysicalInputReadTime(), operatorStats.getInternalNetworkInputDataSize(), operatorStats.getInternalNetworkInputPositions(), operatorStats.getRawInputDataSize(), operatorStats.getInputDataSize(), operatorStats.getInputPositions(), operatorStats.getSumSquaredInputPositions(), operatorStats.getGetOutputCalls(), operatorStats.getGetOutputWall(), operatorStats.getGetOutputCpu(), operatorStats.getOutputDataSize(), operatorStats.getOutputPositions(), operatorStats.getDynamicFilterSplitsProcessed(), DistributionSnapshot.pruneMetrics(operatorStats.getMetrics()), DistributionSnapshot.pruneMetrics(operatorStats.getConnectorMetrics()), DistributionSnapshot.pruneMetrics(operatorStats.getPipelineMetrics()), operatorStats.getPhysicalWrittenDataSize(), operatorStats.getBlockedWall(), operatorStats.getFinishCalls(), operatorStats.getFinishWall(), operatorStats.getFinishCpu(), operatorStats.getUserMemoryReservation(), operatorStats.getRevocableMemoryReservation(), operatorStats.getPeakUserMemoryReservation(), operatorStats.getPeakRevocableMemoryReservation(), operatorStats.getPeakTotalMemoryReservation(), operatorStats.getSpilledDataSize(), operatorStats.getBlockedReason(), operatorStats.getInfo());
    }

    private static Metrics pruneMetrics(Metrics metrics) {
        return new Metrics((Map)metrics.getMetrics().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            Metric metric = (Metric)entry.getValue();
            if (metric instanceof Distribution) {
                return new DistributionSnapshot((Distribution)metric);
            }
            return metric;
        })));
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").add("count", this.total).add("p01", (Object)DistributionSnapshot.formatDouble(this.p01)).add("p05", (Object)DistributionSnapshot.formatDouble(this.p05)).add("p10", (Object)DistributionSnapshot.formatDouble(this.p10)).add("p25", (Object)DistributionSnapshot.formatDouble(this.p25)).add("p50", (Object)DistributionSnapshot.formatDouble(this.p50)).add("p75", (Object)DistributionSnapshot.formatDouble(this.p75)).add("p90", (Object)DistributionSnapshot.formatDouble(this.p90)).add("p95", (Object)DistributionSnapshot.formatDouble(this.p95)).add("p99", (Object)DistributionSnapshot.formatDouble(this.p99)).add("min", (Object)DistributionSnapshot.formatDouble(this.min)).add("max", (Object)DistributionSnapshot.formatDouble(this.max));
        return helper.toString();
    }

    public DistributionSnapshot mergeWith(DistributionSnapshot other) {
        throw new UnsupportedOperationException("Merging of DistributionSnapshot is not supported");
    }

    private static String formatDouble(double value) {
        return String.format(Locale.US, "%.2f", value);
    }
}

