/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.client.ErrorInfo;
import io.trino.client.ErrorLocation;
import io.trino.client.FailureInfo;
import io.trino.execution.Failure;
import io.trino.spi.ErrorCode;
import io.trino.spi.HostAddress;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

@Immutable
public class ExecutionFailureInfo {
    private final String type;
    private final String message;
    private final ExecutionFailureInfo cause;
    private final List<ExecutionFailureInfo> suppressed;
    private final List<String> stack;
    private final ErrorLocation errorLocation;
    private final ErrorCode errorCode;
    private final HostAddress remoteHost;

    @JsonCreator
    public ExecutionFailureInfo(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="cause") ExecutionFailureInfo cause, @JsonProperty(value="suppressed") List<ExecutionFailureInfo> suppressed, @JsonProperty(value="stack") List<String> stack, @JsonProperty(value="errorLocation") @Nullable ErrorLocation errorLocation, @JsonProperty(value="errorCode") @Nullable ErrorCode errorCode, @JsonProperty(value="remoteHost") @Nullable HostAddress remoteHost) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(suppressed, "suppressed is null");
        Objects.requireNonNull(stack, "stack is null");
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
        this.errorLocation = errorLocation;
        this.errorCode = errorCode;
        this.remoteHost = remoteHost;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @JsonProperty
    public ExecutionFailureInfo getCause() {
        return this.cause;
    }

    @JsonProperty
    public List<ExecutionFailureInfo> getSuppressed() {
        return this.suppressed;
    }

    @JsonProperty
    public List<String> getStack() {
        return this.stack;
    }

    @Nullable
    @JsonProperty
    public ErrorLocation getErrorLocation() {
        return this.errorLocation;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    @JsonProperty
    public HostAddress getRemoteHost() {
        return this.remoteHost;
    }

    public FailureInfo toFailureInfo() {
        List suppressed = (List)this.suppressed.stream().map(ExecutionFailureInfo::toFailureInfo).collect(ImmutableList.toImmutableList());
        ErrorInfo errorInfo = null;
        if (this.errorCode != null) {
            errorInfo = new ErrorInfo(this.errorCode.getCode(), this.errorCode.getName(), this.errorCode.getType().toString());
        }
        return new FailureInfo(this.type, this.message, this.cause == null ? null : this.cause.toFailureInfo(), suppressed, this.stack, errorInfo, this.errorLocation);
    }

    public RuntimeException toException() {
        return new Failure(this);
    }
}

