/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.ParameterExtractor;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.sql.analyzer.ConstantExpressionVerifier;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.ExecuteImmediate;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import io.trino.util.StatementUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryPreparer {
    private final SqlParser sqlParser;

    @Inject
    public QueryPreparer(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public PreparedQuery prepareQuery(Session session, String query) throws ParsingException, TrinoException {
        Statement wrappedStatement = this.sqlParser.createStatement(query);
        return this.prepareQuery(session, wrappedStatement);
    }

    public PreparedQuery prepareQuery(Session session, Statement wrappedStatement) throws ParsingException, TrinoException {
        ExplainAnalyze explainAnalyzeStatement;
        Statement innerStatement;
        Optional<QueryType> innerQueryType;
        Statement statement = wrappedStatement;
        Optional<Object> prepareSql = Optional.empty();
        if (statement instanceof Execute) {
            Execute executeStatement = (Execute)statement;
            prepareSql = Optional.of(session.getPreparedStatementFromExecute(executeStatement));
            statement = this.sqlParser.createStatement((String)prepareSql.get());
        } else if (statement instanceof ExecuteImmediate) {
            ExecuteImmediate executeImmediateStatement = (ExecuteImmediate)statement;
            statement = this.sqlParser.createStatement(executeImmediateStatement.getStatement().getValue(), (NodeLocation)executeImmediateStatement.getStatement().getLocation().orElseThrow());
        } else if (statement instanceof ExplainAnalyze && ((innerQueryType = StatementUtils.getQueryType(innerStatement = (explainAnalyzeStatement = (ExplainAnalyze)statement).getStatement())).isEmpty() || innerQueryType.get() == QueryType.DATA_DEFINITION)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "EXPLAIN ANALYZE doesn't support statement type: " + innerStatement.getClass().getSimpleName());
        }
        Object parameters = ImmutableList.of();
        if (wrappedStatement instanceof Execute) {
            Execute executeStatement = (Execute)wrappedStatement;
            parameters = executeStatement.getParameters();
        } else if (wrappedStatement instanceof ExecuteImmediate) {
            ExecuteImmediate executeImmediateStatement = (ExecuteImmediate)wrappedStatement;
            parameters = executeImmediateStatement.getParameters();
        }
        QueryPreparer.validateParameters(statement, (List<Expression>)parameters);
        return new PreparedQuery(statement, (List<Expression>)parameters, prepareSql);
    }

    private static void validateParameters(Statement node, List<Expression> parameterValues) {
        int parameterCount = ParameterExtractor.getParameterCount(node);
        if (parameterValues.size() != parameterCount) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Incorrect number of parameters: expected %s but found %s", parameterCount, parameterValues.size());
        }
        for (Expression expression : parameterValues) {
            ConstantExpressionVerifier.verifyExpressionIsConstant(Collections.emptySet(), expression);
        }
    }

    public static class PreparedQuery {
        private final Statement statement;
        private final List<Expression> parameters;
        private final Optional<String> prepareSql;

        public PreparedQuery(Statement statement, List<Expression> parameters, Optional<String> prepareSql) {
            this.statement = Objects.requireNonNull(statement, "statement is null");
            this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
            this.prepareSql = Objects.requireNonNull(prepareSql, "prepareSql is null");
        }

        public Statement getStatement() {
            return this.statement;
        }

        public List<Expression> getParameters() {
            return this.parameters;
        }

        public Optional<String> getPrepareSql() {
            return this.prepareSql;
        }
    }
}

