/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

public enum TaskState {
    PLANNED(false, false),
    RUNNING(false, false),
    FLUSHING(false, false),
    FINISHED(true, false),
    CANCELING(false, true),
    CANCELED(true, false),
    ABORTING(false, true),
    ABORTED(true, false),
    FAILING(false, true),
    FAILED(true, false);

    public static final Set<TaskState> TERMINAL_TASK_STATES;
    private final boolean doneState;
    private final boolean terminating;

    private TaskState(boolean doneState, boolean terminating) {
        this.doneState = doneState;
        this.terminating = terminating;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public boolean isTerminating() {
        return this.terminating;
    }

    public boolean isTerminatingOrDone() {
        return this.terminating | this.doneState;
    }

    static {
        TERMINAL_TASK_STATES = (Set)Stream.of(TaskState.values()).filter(TaskState::isDone).collect(ImmutableSet.toImmutableSet());
    }
}

