/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import java.util.Objects;

public class SpoolingOutputBuffers
extends OutputBuffers {
    private final ExchangeSinkInstanceHandle exchangeSinkInstanceHandle;
    private final int outputPartitionCount;

    public static SpoolingOutputBuffers createInitial(ExchangeSinkInstanceHandle exchangeSinkInstanceHandle, int outputPartitionCount) {
        return new SpoolingOutputBuffers(0L, exchangeSinkInstanceHandle, outputPartitionCount);
    }

    @JsonCreator
    public SpoolingOutputBuffers(@JsonProperty(value="version") long version, @JsonProperty(value="exchangeSinkInstanceHandle") ExchangeSinkInstanceHandle exchangeSinkInstanceHandle, @JsonProperty(value="outputPartitionCount") int outputPartitionCount) {
        super(version);
        this.exchangeSinkInstanceHandle = Objects.requireNonNull(exchangeSinkInstanceHandle, "exchangeSinkInstanceHandle is null");
        Preconditions.checkArgument((outputPartitionCount > 0 ? 1 : 0) != 0, (Object)"outputPartitionCount must be greater than zero");
        this.outputPartitionCount = outputPartitionCount;
    }

    @JsonProperty
    public ExchangeSinkInstanceHandle getExchangeSinkInstanceHandle() {
        return this.exchangeSinkInstanceHandle;
    }

    @JsonProperty
    public int getOutputPartitionCount() {
        return this.outputPartitionCount;
    }

    @Override
    public void checkValidTransition(OutputBuffers outputBuffers) {
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Preconditions.checkArgument((boolean)(outputBuffers instanceof SpoolingOutputBuffers), (Object)"outputBuffers is expected to be an instance of SpoolingOutputBuffers");
        if (this.getVersion() > outputBuffers.getVersion()) {
            throw new IllegalArgumentException("new outputBuffers version is older");
        }
        SpoolingOutputBuffers newOutputBuffers = (SpoolingOutputBuffers)outputBuffers;
        Preconditions.checkArgument((this.getOutputPartitionCount() == newOutputBuffers.getOutputPartitionCount() ? 1 : 0) != 0, (String)"number of output partitions must be the same: %s != %s", (int)this.getOutputPartitionCount(), (int)newOutputBuffers.getOutputPartitionCount());
    }

    public SpoolingOutputBuffers withExchangeSinkInstanceHandle(ExchangeSinkInstanceHandle handle) {
        return new SpoolingOutputBuffers(this.getVersion() + 1L, handle, this.outputPartitionCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exchangeSinkInstanceHandle", (Object)this.exchangeSinkInstanceHandle).add("outputPartitionCount", this.outputPartitionCount).toString();
    }
}

