/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public final class SchedulingUtils {
    private SchedulingUtils() {
    }

    public static boolean canStream(SubPlan plan, SubPlan source) {
        PlanFragmentId sourceFragmentId = source.getFragment().getId();
        PlanNode root = plan.getFragment().getRoot();
        RemoteSourceNode sourceNode = (RemoteSourceNode)plan.getFragment().getRemoteSourceNodes().stream().filter(node -> node.getSourceFragmentIds().contains(sourceFragmentId)).collect(MoreCollectors.onlyElement());
        List<PlanNode> pathToSource = SchedulingUtils.findPath(root, sourceNode).orElseThrow(() -> new RuntimeException("Could not find path from %s to %s in %s".formatted(root, sourceNode, plan.getFragment())));
        for (int pos = 0; pos < pathToSource.size() - 1; ++pos) {
            PlanNode child;
            PlanNode leftSource;
            PlanNode node2 = pathToSource.get(pos);
            if (!(node2 instanceof JoinNode) && !(node2 instanceof SemiJoinNode) && !(node2 instanceof IndexJoinNode) && !(node2 instanceof SpatialJoinNode) || (leftSource = node2.getSources().get(0)) == (child = pathToSource.get(pos + 1))) continue;
            return false;
        }
        return true;
    }

    private static Optional<List<PlanNode>> findPath(PlanNode start, final PlanNode end) {
        PlanVisitor<Optional<List<PlanNode>>, Deque<PlanNode>> visitor = new PlanVisitor<Optional<List<PlanNode>>, Deque<PlanNode>>(){

            @Override
            protected Optional<List<PlanNode>> visitPlan(PlanNode node, Deque<PlanNode> queue) {
                queue.add(node);
                if (node == end) {
                    return Optional.of(ImmutableList.copyOf(queue));
                }
                for (PlanNode source : node.getSources()) {
                    Optional<List<PlanNode>> result = source.accept(this, queue);
                    if (!result.isPresent()) continue;
                    return result;
                }
                queue.removeLast();
                return Optional.empty();
            }
        };
        return start.accept(visitor, new ArrayDeque());
    }
}

