/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.faulttolerant.NodeAllocator;
import io.trino.execution.scheduler.faulttolerant.NodeAllocatorService;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.TaskExecutionClass;
import io.trino.memory.ClusterMemoryManager;
import io.trino.memory.MemoryInfo;
import io.trino.memory.MemoryManagerConfig;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.memory.MemoryPoolInfo;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.util.VisibleForTesting;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
@ThreadSafe
public class BinPackingNodeAllocatorService
implements NodeAllocatorService {
    private static final Logger log = Logger.get(BinPackingNodeAllocatorService.class);
    @VisibleForTesting
    static final int PROCESS_PENDING_ACQUIRES_DELAY_SECONDS = 5;
    private final InternalNodeManager nodeManager;
    private final Supplier<Map<String, Optional<MemoryInfo>>> workerMemoryInfoSupplier;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(3, Threads.daemonThreadsNamed((String)"bin-packing-node-allocator"));
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final Semaphore processSemaphore = new Semaphore(0);
    private final AtomicReference<Map<String, MemoryPoolInfo>> nodePoolMemoryInfos = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private final boolean scheduleOnCoordinator;
    private final DataSize taskRuntimeMemoryEstimationOverhead;
    private final DataSize eagerSpeculativeTasksNodeMemoryOvercommit;
    private final Ticker ticker;
    private final ConcurrentNavigableMap<QueryId, Deque<PendingAcquire>> pendingAcquires = new ConcurrentSkipListMap<QueryId, Deque<PendingAcquire>>((Comparator<QueryId>)Ordering.natural().onResultOf(QueryId::getId));
    private final Set<BinPackingNodeLease> fulfilledAcquires = Sets.newConcurrentHashSet();
    private final Duration allowedNoMatchingNodePeriod;
    private final Duration exhaustedNodeWaitPeriod;
    private final boolean optimizedLocalScheduling;
    private final StatsHolder stats = new StatsHolder();
    private final CounterStat processCalls = new CounterStat();
    private final CounterStat processPending = new CounterStat();
    private Optional<QueryId> startingQueryId = Optional.empty();

    @Inject
    public BinPackingNodeAllocatorService(InternalNodeManager nodeManager, ClusterMemoryManager clusterMemoryManager, NodeSchedulerConfig nodeSchedulerConfig, MemoryManagerConfig memoryManagerConfig) {
        this(nodeManager, clusterMemoryManager::getAllNodesMemoryInfo, nodeSchedulerConfig.isIncludeCoordinator(), Duration.ofMillis(nodeSchedulerConfig.getAllowedNoMatchingNodePeriod().toMillis()), Duration.ofMillis(nodeSchedulerConfig.getExhaustedNodeWaitPeriod().toMillis()), nodeSchedulerConfig.getOptimizedLocalScheduling(), memoryManagerConfig.getFaultTolerantExecutionTaskRuntimeMemoryEstimationOverhead(), memoryManagerConfig.getFaultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit(), Ticker.systemTicker());
    }

    @VisibleForTesting
    BinPackingNodeAllocatorService(InternalNodeManager nodeManager, Supplier<Map<String, Optional<MemoryInfo>>> workerMemoryInfoSupplier, boolean scheduleOnCoordinator, Duration allowedNoMatchingNodePeriod, Duration exhaustedNodeWaitPeriod, boolean optimizedLocalScheduling, DataSize taskRuntimeMemoryEstimationOverhead, DataSize eagerSpeculativeTasksNodeMemoryOvercommit, Ticker ticker) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.workerMemoryInfoSupplier = Objects.requireNonNull(workerMemoryInfoSupplier, "workerMemoryInfoSupplier is null");
        this.scheduleOnCoordinator = scheduleOnCoordinator;
        this.allowedNoMatchingNodePeriod = Objects.requireNonNull(allowedNoMatchingNodePeriod, "allowedNoMatchingNodePeriod is null");
        this.exhaustedNodeWaitPeriod = Objects.requireNonNull(exhaustedNodeWaitPeriod, "exhaustedNodeWaitPeriod is null");
        this.optimizedLocalScheduling = optimizedLocalScheduling;
        this.taskRuntimeMemoryEstimationOverhead = Objects.requireNonNull(taskRuntimeMemoryEstimationOverhead, "taskRuntimeMemoryEstimationOverhead is null");
        this.eagerSpeculativeTasksNodeMemoryOvercommit = eagerSpeculativeTasksNodeMemoryOvercommit;
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.executor.schedule(() -> {
                while (!this.stopped.get()) {
                    try {
                        this.processSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
                        this.processSemaphore.drainPermits();
                        this.processPendingAcquires();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable e) {
                        log.error(e, "Error processing pending acquires");
                    }
                }
            }, 0L, TimeUnit.SECONDS);
        }
        this.refreshNodePoolMemoryInfos();
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.refreshNodePoolMemoryInfos();
            }
            catch (Throwable e) {
                log.error(e, "Unexpected error while refreshing node pool memory infos");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.updateStats();
            }
            catch (Throwable e) {
                log.error(e, "Unexpected error while updating stats");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.stopped.set(true);
        this.executor.shutdownNow();
    }

    @VisibleForTesting
    void refreshNodePoolMemoryInfos() {
        ImmutableMap.Builder newNodePoolMemoryInfos = ImmutableMap.builder();
        Map<String, Optional<MemoryInfo>> workerMemoryInfos = this.workerMemoryInfoSupplier.get();
        long maxNodePoolSizeBytes = -1L;
        for (Map.Entry<String, Optional<MemoryInfo>> entry : workerMemoryInfos.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            MemoryPoolInfo poolInfo = entry.getValue().get().getPool();
            newNodePoolMemoryInfos.put((Object)entry.getKey(), (Object)poolInfo);
            maxNodePoolSizeBytes = Math.max(poolInfo.getMaxBytes(), maxNodePoolSizeBytes);
        }
        this.nodePoolMemoryInfos.set((Map<String, MemoryPoolInfo>)newNodePoolMemoryInfos.buildOrThrow());
    }

    @VisibleForTesting
    synchronized void processPendingAcquires() {
        this.processCalls.update(1L);
        this.processPendingAcquires(TaskExecutionClass.EAGER_SPECULATIVE);
        this.processPendingAcquires(TaskExecutionClass.STANDARD);
        boolean hasNonSpeculativePendingAcquires = this.pendingAcquires.values().stream().flatMap(Collection::stream).anyMatch(pendingAcquire -> !pendingAcquire.isSpeculative());
        if (!hasNonSpeculativePendingAcquires) {
            this.processPendingAcquires(TaskExecutionClass.SPECULATIVE);
        }
    }

    private void processPendingAcquires(TaskExecutionClass executionClass) {
        Iterator<PendingAcquire> iterator = this.pendingAcquiresIterator(this.startingQueryId);
        BinPackingSimulation simulation = new BinPackingSimulation(this.nodeManager.getActiveNodesSnapshot(), this.nodePoolMemoryInfos.get(), this.fulfilledAcquires, this.scheduleOnCoordinator, this.optimizedLocalScheduling, this.taskRuntimeMemoryEstimationOverhead, executionClass == TaskExecutionClass.EAGER_SPECULATIVE ? this.eagerSpeculativeTasksNodeMemoryOvercommit : DataSize.ofBytes((long)0L), executionClass == TaskExecutionClass.STANDARD, this.exhaustedNodeWaitPeriod);
        boolean allReservedSoFar = true;
        while (iterator.hasNext()) {
            PendingAcquire pendingAcquire = iterator.next();
            if (pendingAcquire.getFuture().isCancelled()) {
                iterator.remove();
                continue;
            }
            if (pendingAcquire.getExecutionClass() != executionClass) continue;
            this.processPending.update(1L);
            BinPackingSimulation.ReserveResult result = simulation.tryReserve(pendingAcquire);
            pendingAcquire.setLastReservationStatus(result.getStatus());
            if (result.getStatus() != BinPackingSimulation.ReservationStatus.RESERVED && allReservedSoFar) {
                allReservedSoFar = false;
                this.startingQueryId = Optional.of(pendingAcquire.getQueryId());
            }
            switch (result.getStatus().ordinal()) {
                case 2: {
                    InternalNode reservedNode = result.getNode();
                    this.fulfilledAcquires.add(pendingAcquire.getLease());
                    pendingAcquire.getFuture().set((Object)reservedNode);
                    if (pendingAcquire.getFuture().isCancelled()) {
                        this.fulfilledAcquires.remove(pendingAcquire.getLease());
                        this.wakeupProcessPendingAcquires();
                    }
                    iterator.remove();
                    break;
                }
                case 0: {
                    Duration noMatchingNodePeriod = pendingAcquire.markNoMatchingNodeFound();
                    if (noMatchingNodePeriod.compareTo(this.allowedNoMatchingNodePeriod) <= 0) break;
                    pendingAcquire.getFuture().setException((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query"));
                    iterator.remove();
                    break;
                }
                case 1: {
                    pendingAcquire.resetNoMatchingNodeFound();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown status: " + String.valueOf((Object)result.getStatus()));
                }
            }
        }
    }

    private Iterator<PendingAcquire> pendingAcquiresIterator(Optional<QueryId> startingQueryId) {
        final List iterators = this.pendingAcquires.entrySet().stream().map(entry -> new QueryPendingAcquires((QueryId)entry.getKey(), ((Deque)entry.getValue()).iterator())).collect(Collectors.toCollection(ArrayList::new));
        int startingIteratorIndex = 0;
        if (startingQueryId.isPresent()) {
            startingIteratorIndex = -1;
            for (int i = 0; i < iterators.size(); ++i) {
                if (!((QueryPendingAcquires)iterators.get(i)).queryId().equals((Object)startingQueryId.get())) continue;
                startingIteratorIndex = i;
                break;
            }
            if (startingIteratorIndex == -1) {
                startingIteratorIndex = ThreadLocalRandom.current().nextInt(iterators.size());
            }
        }
        final int finalStartingIteratorIndex = startingIteratorIndex;
        return new Iterator<PendingAcquire>(this){
            int currentIterator;
            int removeIterator;
            {
                this.currentIterator = finalStartingIteratorIndex;
                this.removeIterator = -1;
            }

            @Override
            public boolean hasNext() {
                while (!iterators.isEmpty()) {
                    Iterator<PendingAcquire> iterator = ((QueryPendingAcquires)iterators.get(this.currentIterator)).iterator();
                    if (!iterator.hasNext()) {
                        this.dropCurrentIterator();
                        continue;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public PendingAcquire next() {
                while (!iterators.isEmpty()) {
                    Iterator<PendingAcquire> iterator = ((QueryPendingAcquires)iterators.get(this.currentIterator)).iterator();
                    if (!iterator.hasNext()) {
                        this.dropCurrentIterator();
                        continue;
                    }
                    this.removeIterator = this.currentIterator++;
                    this.currentIterator %= iterators.size();
                    return iterator.next();
                }
                throw new NoSuchElementException();
            }

            private void dropCurrentIterator() {
                iterators.remove(this.currentIterator);
                if (this.currentIterator >= iterators.size()) {
                    this.currentIterator = 0;
                }
            }

            @Override
            public void remove() {
                Preconditions.checkState((this.removeIterator != -1 ? 1 : 0) != 0, (Object)"next() not called or already removed");
                ((QueryPendingAcquires)iterators.get(this.removeIterator)).iterator().remove();
                this.removeIterator = -1;
            }
        };
    }

    private void wakeupProcessPendingAcquires() {
        this.processSemaphore.release();
    }

    @Override
    public NodeAllocator getNodeAllocator(final Session session) {
        return new NodeAllocator(){
            final /* synthetic */ BinPackingNodeAllocatorService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public NodeAllocator.NodeLease acquire(NodeRequirements nodeRequirements, DataSize memoryRequirement, TaskExecutionClass executionClass) {
                return this.this$0.acquire(nodeRequirements, memoryRequirement, executionClass, session.getQueryId());
            }

            @Override
            public void close() {
                this.this$0.pendingAcquires.remove(session.getQueryId());
            }
        };
    }

    public NodeAllocator.NodeLease acquire(NodeRequirements nodeRequirements, DataSize memoryRequirement, TaskExecutionClass executionClass, QueryId queryId2) {
        BinPackingNodeLease nodeLease = new BinPackingNodeLease(memoryRequirement.toBytes(), executionClass, nodeRequirements);
        PendingAcquire pendingAcquire = new PendingAcquire(nodeRequirements, nodeLease, queryId2, this.ticker);
        Deque requesterPendingAcquires = this.pendingAcquires.computeIfAbsent(queryId2, queryId -> new ConcurrentLinkedDeque());
        requesterPendingAcquires.add(pendingAcquire);
        this.wakeupProcessPendingAcquires();
        return nodeLease;
    }

    @Managed
    @Nested
    public StatsHolder getStats() {
        return this.stats;
    }

    @Managed
    @Nested
    public CounterStat getProcessCalls() {
        return this.processCalls;
    }

    @Managed
    @Nested
    public CounterStat getProcessPending() {
        return this.processPending;
    }

    /*
     * Exception decompiling
     */
    private void updateStats() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=14,913
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$updateStats$6(DistributionStat fulfilledByNodeCountDistribution, DistributionStat fulfilledByNodeMemoryDistribution, Collection nodeAcquires) {
        fulfilledByNodeCountDistribution.add((long)nodeAcquires.size());
        fulfilledByNodeMemoryDistribution.add(nodeAcquires.stream().mapToLong(BinPackingNodeLease::getMemoryLease).sum());
    }

    public static class StatsHolder {
        private final AtomicReference<Stats> statsReference = new AtomicReference<Stats>(Stats.ZERO);

        public void updateStats(Stats stats) {
            this.statsReference.set(stats);
        }

        @Managed
        public long getPendingStandardNoneMatching() {
            return this.statsReference.get().pendingStandardNoneMatching();
        }

        @Managed
        public long getPendingStandardNotEnoughResources() {
            return this.statsReference.get().pendingStandardNotEnoughResources();
        }

        @Managed
        public long getPendingStandardUnknown() {
            return this.statsReference.get().pendingStandardUnknown();
        }

        @Managed
        public long getPendingSpeculativeNoneMatching() {
            return this.statsReference.get().pendingSpeculativeNoneMatching();
        }

        @Managed
        public long getPendingSpeculativeNotEnoughResources() {
            return this.statsReference.get().pendingSpeculativeNotEnoughResources();
        }

        @Managed
        public long getPendingSpeculativeUnknown() {
            return this.statsReference.get().pendingSpeculativeUnknown();
        }

        @Managed
        public long getPendingEagerSpeculativeNoneMatching() {
            return this.statsReference.get().pendingEagerSpeculativeNoneMatching();
        }

        @Managed
        public long getPendingEagerSpeculativeNotEnoughResources() {
            return this.statsReference.get().pendingEagerSpeculativeNotEnoughResources();
        }

        @Managed
        public long getPendingEagerSpeculativeUnknown() {
            return this.statsReference.get().pendingEagerSpeculativeUnknown();
        }

        @Managed
        public long getFulfilledStandard() {
            return this.statsReference.get().fulfilledStandard();
        }

        @Managed
        public long getFulfilledSpeculative() {
            return this.statsReference.get().fulfilledSpeculative();
        }

        @Managed
        public long getFulfilledEagerSpeculative() {
            return this.statsReference.get().fulfilledEagerSpeculative();
        }

        @Managed
        public DistributionStat getFulfilledByNodeCountDistribution() {
            return this.statsReference.get().fulfilledByNodeCountDistribution();
        }

        @Managed
        public DistributionStat getFulfilledByNodeMemoryDistribution() {
            return this.statsReference.get().fulfilledByNodeMemoryDistribution();
        }
    }

    private static class BinPackingSimulation {
        private final List<InternalNode> allNodesSorted;
        private final List<InternalNode> workerNodesSorted;
        private final Multimap<HostAddress, InternalNode> allNodesByAddress;
        private final boolean ignoreAcquiredSpeculative;
        private final Map<String, Long> nodesRemainingMemory;
        private final Set<String> nodesWithoutMemory;
        private final Map<String, Long> nodesRemainingMemoryRuntimeAdjusted;
        private final Map<String, Long> speculativeMemoryReserved;
        private final NonEvictableLoadingCache<CatalogHandle, List<InternalNode>> catalogNodes;
        private final NonEvictableLoadingCache<CatalogHandle, List<InternalNode>> catalogWorkerNodes;
        private final Map<String, MemoryPoolInfo> nodeMemoryPoolInfos;
        private final boolean scheduleOnCoordinator;
        private final boolean optimizedLocalScheduling;
        private final Duration exhaustedNodeWaitPeriod;

        public BinPackingSimulation(InternalNodeManager.NodesSnapshot nodesSnapshot, Map<String, MemoryPoolInfo> nodeMemoryPoolInfos, Set<BinPackingNodeLease> fulfilledAcquires, boolean scheduleOnCoordinator, boolean optimizedLocalScheduling, DataSize taskRuntimeMemoryEstimationOverhead, DataSize nodeMemoryOvercommit, boolean ignoreAcquiredSpeculative, Duration exhaustedNodeWaitPeriod) {
            MemoryPoolInfo memoryPoolInfo;
            Objects.requireNonNull(nodesSnapshot, "nodesSnapshot is null");
            this.allNodesSorted = (List)nodesSnapshot.getAllNodes().stream().sorted(Comparator.comparing(InternalNode::getNodeIdentifier)).collect(ImmutableList.toImmutableList());
            this.workerNodesSorted = (List)this.allNodesSorted.stream().filter(node -> !node.isCoordinator()).collect(ImmutableList.toImmutableList());
            this.catalogNodes = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder(), (CacheLoader)CacheLoader.from(catalogHandle -> {
                ArrayList<InternalNode> nodes = new ArrayList<InternalNode>(this.allNodesSorted);
                nodes.retainAll(nodesSnapshot.getConnectorNodes((CatalogHandle)catalogHandle));
                return nodes;
            }));
            this.catalogWorkerNodes = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder(), (CacheLoader)CacheLoader.from(catalogHandle -> {
                ArrayList<InternalNode> nodes = new ArrayList<InternalNode>(this.workerNodesSorted);
                nodes.retainAll(nodesSnapshot.getConnectorNodes((CatalogHandle)catalogHandle));
                return nodes;
            }));
            this.allNodesByAddress = Multimaps.index(nodesSnapshot.getAllNodes(), InternalNode::getHostAndPort);
            this.ignoreAcquiredSpeculative = ignoreAcquiredSpeculative;
            Objects.requireNonNull(nodeMemoryPoolInfos, "nodeMemoryPoolInfos is null");
            this.nodeMemoryPoolInfos = ImmutableMap.copyOf(nodeMemoryPoolInfos);
            this.scheduleOnCoordinator = scheduleOnCoordinator;
            this.optimizedLocalScheduling = optimizedLocalScheduling;
            this.exhaustedNodeWaitPeriod = exhaustedNodeWaitPeriod;
            HashMap<String, Object> realtimeTasksMemoryPerNode = new HashMap<String, Object>();
            for (InternalNode node2 : nodesSnapshot.getAllNodes()) {
                MemoryPoolInfo memoryPoolInfo2 = nodeMemoryPoolInfos.get(node2.getNodeIdentifier());
                if (memoryPoolInfo2 == null) {
                    realtimeTasksMemoryPerNode.put(node2.getNodeIdentifier(), ImmutableMap.of());
                    continue;
                }
                realtimeTasksMemoryPerNode.put(node2.getNodeIdentifier(), memoryPoolInfo2.getTaskMemoryReservations());
            }
            HashMap<String, Long> preReservedMemory = new HashMap<String, Long>();
            this.speculativeMemoryReserved = new HashMap<String, Long>();
            HashMultimap fulfilledAcquiresByNode = HashMultimap.create();
            for (BinPackingNodeLease fulfilledAcquire : fulfilledAcquires) {
                InternalNode node3 = fulfilledAcquire.getAssignedNode();
                long memoryLease = fulfilledAcquire.getMemoryLease();
                if (ignoreAcquiredSpeculative && fulfilledAcquire.isSpeculative()) {
                    this.speculativeMemoryReserved.merge(node3.getNodeIdentifier(), memoryLease, Long::sum);
                    continue;
                }
                fulfilledAcquiresByNode.put((Object)node3.getNodeIdentifier(), (Object)fulfilledAcquire);
                preReservedMemory.merge(node3.getNodeIdentifier(), memoryLease, Long::sum);
            }
            this.nodesRemainingMemory = new HashMap<String, Long>();
            for (InternalNode node4 : nodesSnapshot.getAllNodes()) {
                memoryPoolInfo = nodeMemoryPoolInfos.get(node4.getNodeIdentifier());
                if (memoryPoolInfo == null) {
                    this.nodesRemainingMemory.put(node4.getNodeIdentifier(), 0L);
                    continue;
                }
                long nodeReservedMemory = preReservedMemory.getOrDefault(node4.getNodeIdentifier(), 0L);
                this.nodesRemainingMemory.put(node4.getNodeIdentifier(), Math.max(memoryPoolInfo.getMaxBytes() + nodeMemoryOvercommit.toBytes() - nodeReservedMemory, 0L));
            }
            this.nodesWithoutMemory = new HashSet<String>();
            this.nodesRemainingMemoryRuntimeAdjusted = new HashMap<String, Long>();
            for (InternalNode node4 : nodesSnapshot.getAllNodes()) {
                memoryPoolInfo = nodeMemoryPoolInfos.get(node4.getNodeIdentifier());
                if (memoryPoolInfo == null) {
                    this.nodesRemainingMemoryRuntimeAdjusted.put(node4.getNodeIdentifier(), 0L);
                    continue;
                }
                Map realtimeNodeMemory = (Map)realtimeTasksMemoryPerNode.get(node4.getNodeIdentifier());
                Set nodeFulfilledAcquires = fulfilledAcquiresByNode.get((Object)node4.getNodeIdentifier());
                long nodeUsedMemoryRuntimeAdjusted = 0L;
                for (BinPackingNodeLease lease : nodeFulfilledAcquires) {
                    long realtimeTaskMemory = 0L;
                    if (lease.getAttachedTaskId().isPresent()) {
                        realtimeTaskMemory = realtimeNodeMemory.getOrDefault(lease.getAttachedTaskId().get().toString(), 0L);
                        realtimeTaskMemory += taskRuntimeMemoryEstimationOverhead.toBytes();
                    }
                    long reservedTaskMemory = lease.getMemoryLease();
                    nodeUsedMemoryRuntimeAdjusted += Math.max(realtimeTaskMemory, reservedTaskMemory);
                }
                nodeUsedMemoryRuntimeAdjusted = Math.max(nodeUsedMemoryRuntimeAdjusted, memoryPoolInfo.getReservedBytes());
                this.nodesRemainingMemoryRuntimeAdjusted.put(node4.getNodeIdentifier(), Math.max(memoryPoolInfo.getMaxBytes() + nodeMemoryOvercommit.toBytes() - nodeUsedMemoryRuntimeAdjusted, 0L));
            }
        }

        /*
         * Unable to fully structure code
         */
        public ReserveResult tryReserve(PendingAcquire acquire) {
            block8: {
                block7: {
                    requirements = acquire.getNodeRequirements();
                    address = requirements.getAddress();
                    if (!address.isPresent() || !this.optimizedLocalScheduling && requirements.isRemotelyAccessible()) break block7;
                    preferred = this.allNodesByAddress.get((Object)address.get());
                    if (!preferred.isEmpty() && acquire.getNotEnoughResourcesPeriod().compareTo(this.exhaustedNodeWaitPeriod) < 0) ** GOTO lbl10
                    if (!requirements.isRemotelyAccessible()) {
lbl10:
                        // 2 sources

                        candidates = (List<Object>)this.getCandidatesWithCoordinator(requirements).stream().filter((Predicate<InternalNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Lio/trino/metadata/InternalNode;)Z)((Collection)preferred)).collect(ImmutableList.toImmutableList());
                    } else {
                        candidates = this.scheduleOnCoordinator != false ? this.getCandidatesWithCoordinator(requirements) : this.getCandidatesExceptCoordinator(requirements);
                    }
                    break block8;
                }
                v0 = candidates = this.scheduleOnCoordinator != false ? this.getCandidatesWithCoordinator(requirements) : this.getCandidatesExceptCoordinator(requirements);
            }
            if (candidates.isEmpty()) {
                return ReserveResult.NONE_MATCHING;
            }
            if ((candidates = (List<Object>)candidates.stream().filter((Predicate<InternalNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$tryReserve$3(io.trino.metadata.InternalNode ), (Lio/trino/metadata/InternalNode;)Z)((BinPackingSimulation)this)).collect(ImmutableList.toImmutableList())).isEmpty()) {
                return ReserveResult.NOT_ENOUGH_RESOURCES_NOW;
            }
            comparator = Comparator.comparing((Function<InternalNode, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$tryReserve$4(io.trino.metadata.InternalNode ), (Lio/trino/metadata/InternalNode;)Ljava/lang/Long;)((BinPackingSimulation)this));
            if (this.ignoreAcquiredSpeculative) {
                comparator = this.resolveTiesWithSpeculativeMemory(comparator);
            }
            selectedNode = candidates.stream().max(comparator).orElseThrow();
            memoryRequirements = acquire.getMemoryLease();
            if (this.nodesRemainingMemoryRuntimeAdjusted.get(selectedNode.getNodeIdentifier()) >= memoryRequirements || this.isNodeEmpty(selectedNode.getNodeIdentifier())) {
                this.subtractFromRemainingMemory(selectedNode.getNodeIdentifier(), memoryRequirements);
                return ReserveResult.reserved(selectedNode);
            }
            fallbackComparator = Comparator.comparing((Function<InternalNode, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$tryReserve$5(io.trino.metadata.InternalNode ), (Lio/trino/metadata/InternalNode;)Ljava/lang/Long;)((BinPackingSimulation)this));
            if (this.ignoreAcquiredSpeculative) {
                fallbackComparator = this.resolveTiesWithSpeculativeMemory(fallbackComparator);
            }
            fallbackNode = candidates.stream().max(fallbackComparator).orElseThrow();
            this.subtractFromRemainingMemory(fallbackNode.getNodeIdentifier(), memoryRequirements);
            return ReserveResult.NOT_ENOUGH_RESOURCES_NOW;
        }

        private List<InternalNode> getCandidatesExceptCoordinator(NodeRequirements requirements) {
            return requirements.getCatalogHandle().map(arg_0 -> this.catalogWorkerNodes.getUnchecked(arg_0)).orElse(this.workerNodesSorted);
        }

        private List<InternalNode> getCandidatesWithCoordinator(NodeRequirements requirements) {
            return requirements.getCatalogHandle().map(arg_0 -> this.catalogNodes.getUnchecked(arg_0)).orElse(this.allNodesSorted);
        }

        private Comparator<InternalNode> resolveTiesWithSpeculativeMemory(Comparator<InternalNode> comparator) {
            return comparator.thenComparing(node -> -this.speculativeMemoryReserved.getOrDefault(node.getNodeIdentifier(), 0L).longValue());
        }

        private void subtractFromRemainingMemory(String nodeIdentifier, long memoryLease) {
            this.nodesRemainingMemoryRuntimeAdjusted.compute(nodeIdentifier, (key, free) -> Math.max(free - memoryLease, 0L));
            this.nodesRemainingMemory.compute(nodeIdentifier, (key, free) -> Math.max(free - memoryLease, 0L));
            if (this.nodesRemainingMemory.get(nodeIdentifier) == 0L) {
                this.nodesWithoutMemory.add(nodeIdentifier);
            }
        }

        private boolean isNodeEmpty(String nodeIdentifier) {
            return this.nodeMemoryPoolInfos.containsKey(nodeIdentifier) && this.nodesRemainingMemory.get(nodeIdentifier).equals(this.nodeMemoryPoolInfos.get(nodeIdentifier).getMaxBytes());
        }

        private /* synthetic */ Long lambda$tryReserve$5(InternalNode node) {
            return this.nodesRemainingMemory.get(node.getNodeIdentifier());
        }

        private /* synthetic */ Long lambda$tryReserve$4(InternalNode node) {
            return this.nodesRemainingMemoryRuntimeAdjusted.get(node.getNodeIdentifier());
        }

        private /* synthetic */ boolean lambda$tryReserve$3(InternalNode node) {
            return !this.nodesWithoutMemory.contains(node.getNodeIdentifier());
        }

        public static class ReserveResult {
            public static final ReserveResult NONE_MATCHING = new ReserveResult(ReservationStatus.NONE_MATCHING, Optional.empty());
            public static final ReserveResult NOT_ENOUGH_RESOURCES_NOW = new ReserveResult(ReservationStatus.NOT_ENOUGH_RESOURCES_NOW, Optional.empty());
            private final ReservationStatus status;
            private final Optional<InternalNode> node;

            public static ReserveResult reserved(InternalNode node) {
                return new ReserveResult(ReservationStatus.RESERVED, Optional.of(node));
            }

            private ReserveResult(ReservationStatus status, Optional<InternalNode> node) {
                this.status = Objects.requireNonNull(status, "status is null");
                this.node = Objects.requireNonNull(node, "node is null");
                Preconditions.checkArgument((node.isPresent() == (status == ReservationStatus.RESERVED) ? 1 : 0) != 0, (Object)"node must be set iff status is RESERVED");
            }

            public ReservationStatus getStatus() {
                return this.status;
            }

            public InternalNode getNode() {
                return this.node.orElseThrow(() -> new IllegalStateException("node not set"));
            }
        }

        public static enum ReservationStatus {
            NONE_MATCHING,
            NOT_ENOUGH_RESOURCES_NOW,
            RESERVED;

        }
    }

    private static class PendingAcquire {
        private final NodeRequirements nodeRequirements;
        private final BinPackingNodeLease lease;
        private final QueryId queryId;
        private final Stopwatch noMatchingNodeStopwatch;
        private final Stopwatch notEnoughResourcesStopwatch;
        @Nullable
        private volatile BinPackingSimulation.ReservationStatus lastReservationStatus;

        private PendingAcquire(NodeRequirements nodeRequirements, BinPackingNodeLease lease, QueryId queryId, Ticker ticker) {
            this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
            this.lease = Objects.requireNonNull(lease, "lease is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.noMatchingNodeStopwatch = Stopwatch.createUnstarted((Ticker)ticker);
            this.notEnoughResourcesStopwatch = Stopwatch.createStarted((Ticker)ticker);
        }

        public NodeRequirements getNodeRequirements() {
            return this.nodeRequirements;
        }

        public BinPackingNodeLease getLease() {
            return this.lease;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public SettableFuture<InternalNode> getFuture() {
            return this.lease.getNodeSettableFuture();
        }

        public long getMemoryLease() {
            return this.lease.getMemoryLease();
        }

        public Duration markNoMatchingNodeFound() {
            if (!this.noMatchingNodeStopwatch.isRunning()) {
                this.noMatchingNodeStopwatch.start();
            }
            return this.noMatchingNodeStopwatch.elapsed();
        }

        public Duration getNotEnoughResourcesPeriod() {
            return this.notEnoughResourcesStopwatch.elapsed();
        }

        public void resetNoMatchingNodeFound() {
            this.noMatchingNodeStopwatch.reset();
        }

        public boolean isSpeculative() {
            return this.lease.isSpeculative();
        }

        public TaskExecutionClass getExecutionClass() {
            return this.lease.getExecutionClass();
        }

        @Nullable
        public BinPackingSimulation.ReservationStatus getLastReservationStatus() {
            return this.lastReservationStatus;
        }

        public void setLastReservationStatus(BinPackingSimulation.ReservationStatus lastReservationStatus) {
            Objects.requireNonNull(lastReservationStatus, "lastReservationStatus is null");
            this.lastReservationStatus = lastReservationStatus;
        }
    }

    private class BinPackingNodeLease
    implements NodeAllocator.NodeLease {
        private final SettableFuture<InternalNode> node = SettableFuture.create();
        private final AtomicBoolean released = new AtomicBoolean();
        private final AtomicLong memoryLease;
        private final AtomicReference<TaskId> taskId = new AtomicReference();
        private final AtomicReference<TaskExecutionClass> executionClass;
        private final NodeRequirements nodeRequirements;

        private BinPackingNodeLease(long memoryLease, TaskExecutionClass executionClass, NodeRequirements nodeRequirements) {
            this.memoryLease = new AtomicLong(memoryLease);
            Objects.requireNonNull(executionClass, "executionClass is null");
            this.executionClass = new AtomicReference<TaskExecutionClass>(executionClass);
            this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
        }

        @Override
        public ListenableFuture<InternalNode> getNode() {
            return this.node;
        }

        InternalNode getAssignedNode() {
            try {
                return (InternalNode)Futures.getDone(this.node);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        SettableFuture<InternalNode> getNodeSettableFuture() {
            return this.node;
        }

        @Override
        public void attachTaskId(TaskId taskId) {
            if (!this.taskId.compareAndSet(null, taskId)) {
                throw new IllegalStateException("cannot attach taskId " + String.valueOf(taskId) + "; already attached to " + String.valueOf(this.taskId.get()));
            }
        }

        @Override
        public void setExecutionClass(TaskExecutionClass newExecutionClass) {
            TaskExecutionClass changedFrom = this.executionClass.getAndUpdate(oldExecutionClass -> {
                Preconditions.checkArgument((boolean)oldExecutionClass.canTransitionTo(newExecutionClass), (String)"cannot change execution class from %s to %s", (Object)oldExecutionClass, (Object)((Object)newExecutionClass));
                return newExecutionClass;
            });
            if (changedFrom != newExecutionClass) {
                BinPackingNodeAllocatorService.this.wakeupProcessPendingAcquires();
            }
        }

        public boolean isSpeculative() {
            return this.executionClass.get().isSpeculative();
        }

        public TaskExecutionClass getExecutionClass() {
            return this.executionClass.get();
        }

        public Optional<TaskId> getAttachedTaskId() {
            return Optional.ofNullable(this.taskId.get());
        }

        @Override
        public void setMemoryRequirement(DataSize memoryRequirement) {
            long previousBytes;
            long newBytes = memoryRequirement.toBytes();
            if (newBytes < (previousBytes = this.memoryLease.getAndSet(newBytes))) {
                BinPackingNodeAllocatorService.this.wakeupProcessPendingAcquires();
            }
        }

        public long getMemoryLease() {
            return this.memoryLease.get();
        }

        @Override
        public void release() {
            if (this.released.compareAndSet(false, true)) {
                this.node.cancel(true);
                if (this.node.isDone() && !this.node.isCancelled()) {
                    Preconditions.checkState((boolean)BinPackingNodeAllocatorService.this.fulfilledAcquires.remove(this), (String)"node lease %s not found in fulfilledAcquires %s", (Object)this, BinPackingNodeAllocatorService.this.fulfilledAcquires);
                    BinPackingNodeAllocatorService.this.wakeupProcessPendingAcquires();
                }
            } else {
                throw new IllegalStateException("Node " + String.valueOf(this.node) + " already released");
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("node", this.node).add("released", (Object)this.released).add("memoryLease", (Object)this.memoryLease).add("taskId", this.taskId).add("executionClass", this.executionClass).add("nodeRequirements", (Object)this.nodeRequirements).toString();
        }
    }

    private record QueryPendingAcquires(QueryId queryId, Iterator<PendingAcquire> iterator) {
        private QueryPendingAcquires {
            Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(iterator, "iterator is null");
        }
    }

    private record Stats(long pendingStandardNoneMatching, long pendingStandardNotEnoughResources, long pendingStandardUnknown, long pendingSpeculativeNoneMatching, long pendingSpeculativeNotEnoughResources, long pendingSpeculativeUnknown, long pendingEagerSpeculativeNoneMatching, long pendingEagerSpeculativeNotEnoughResources, long pendingEagerSpeculativeUnknown, long fulfilledStandard, long fulfilledSpeculative, long fulfilledEagerSpeculative, DistributionStat fulfilledByNodeCountDistribution, DistributionStat fulfilledByNodeMemoryDistribution) {
        static final Stats ZERO = new Stats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, new DistributionStat(), new DistributionStat());

        private Stats {
            Objects.requireNonNull(fulfilledByNodeCountDistribution, "fulfilledByNodeCountDistribution is null");
            Objects.requireNonNull(fulfilledByNodeMemoryDistribution, "fulfilledByNodeMemoryDistribution is null");
        }
    }
}

