/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.inject.Inject;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.MemoryPool;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public final class LocalMemoryManagerExporter {
    public static final String EXPORTED_POOL_NAME = "general";
    private final MBeanExporter exporter;
    private final boolean poolExported;

    @Inject
    public LocalMemoryManagerExporter(LocalMemoryManager memoryManager, MBeanExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        boolean poolExportedLocal = false;
        try {
            this.exporter.exportWithGeneratedName((Object)memoryManager.getMemoryPool(), MemoryPool.class, EXPORTED_POOL_NAME);
            poolExportedLocal = true;
        }
        catch (JmxException jmxException) {
            // empty catch block
        }
        this.poolExported = poolExportedLocal;
    }

    @PreDestroy
    public void destroy() {
        if (!this.poolExported) {
            return;
        }
        String objectName = ObjectNames.builder(MemoryPool.class, (String)EXPORTED_POOL_NAME).build();
        try {
            this.exporter.unexport(objectName);
        }
        catch (JmxException jmxException) {
            // empty catch block
        }
    }
}

