/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.Maps;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.TableProcedureMetadata;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

@ThreadSafe
public class CatalogTableProcedures {
    private final Map<String, TableProcedureMetadata> procedures;

    public CatalogTableProcedures(Collection<TableProcedureMetadata> procedures) {
        Objects.requireNonNull(procedures, "procedures is null");
        this.procedures = Maps.uniqueIndex(procedures, TableProcedureMetadata::getName);
    }

    public Collection<TableProcedureMetadata> getTableProcedures() {
        return this.procedures.values();
    }

    public TableProcedureMetadata getTableProcedure(String name) {
        TableProcedureMetadata procedure = this.procedures.get(name);
        if (procedure == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_NOT_FOUND, "Table procedure not registered: " + name);
        }
        return procedure;
    }
}

