/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.aggregation.Aggregator;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;

public class AggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext userMemoryContext;
    private final List<Aggregator> aggregates;
    private State state = State.NEEDS_INPUT;

    public AggregationOperator(OperatorContext operatorContext, List<AggregatorFactory> aggregatorFactories) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.userMemoryContext = operatorContext.localUserMemoryContext();
        this.aggregates = (List)aggregatorFactories.stream().map(AggregatorFactory::createAggregator).collect(ImmutableList.toImmutableList());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
        }
    }

    @Override
    public void close() {
        this.userMemoryContext.setBytes(0L);
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        long memorySize = 0L;
        for (Aggregator aggregate : this.aggregates) {
            aggregate.processPage(page);
            memorySize += aggregate.getEstimatedSize();
        }
        this.userMemoryContext.setBytes(memorySize);
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        List types = (List)this.aggregates.stream().map(Aggregator::getType).collect(ImmutableList.toImmutableList());
        PageBuilder pageBuilder = new PageBuilder(1, types);
        pageBuilder.declarePosition();
        for (int i = 0; i < this.aggregates.size(); ++i) {
            Aggregator aggregator = this.aggregates.get(i);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
            aggregator.evaluate(blockBuilder);
        }
        this.state = State.FINISHED;
        return pageBuilder.build();
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class AggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<AggregatorFactory> aggregatorFactories;
        private boolean closed;

        public AggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<AggregatorFactory> aggregatorFactories) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.aggregatorFactories = ImmutableList.copyOf(aggregatorFactories);
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, AggregationOperator.class.getSimpleName());
            return new AggregationOperator(operatorContext, this.aggregatorFactories);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new AggregationOperatorFactory(this.operatorId, this.planNodeId, this.aggregatorFactories);
        }
    }
}

