/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.sql.planner.plan.JoinType;
import java.util.Objects;

public class JoinOperatorType {
    private final LookupJoinOperatorFactory.JoinType type;
    private final boolean outputSingleMatch;
    private final boolean waitForBuild;

    public static JoinOperatorType ofJoinNodeType(JoinType joinNodeType, boolean outputSingleMatch, boolean waitForBuild) {
        return switch (joinNodeType) {
            default -> throw new MatchException(null, null);
            case JoinType.INNER -> JoinOperatorType.innerJoin(outputSingleMatch, waitForBuild);
            case JoinType.LEFT -> JoinOperatorType.probeOuterJoin(outputSingleMatch);
            case JoinType.RIGHT -> JoinOperatorType.lookupOuterJoin(waitForBuild);
            case JoinType.FULL -> JoinOperatorType.fullOuterJoin();
        };
    }

    public static JoinOperatorType innerJoin(boolean outputSingleMatch, boolean waitForBuild) {
        return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.INNER, outputSingleMatch, waitForBuild);
    }

    public static JoinOperatorType probeOuterJoin(boolean outputSingleMatch) {
        return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.PROBE_OUTER, outputSingleMatch, false);
    }

    public static JoinOperatorType lookupOuterJoin(boolean waitForBuild) {
        return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.LOOKUP_OUTER, false, waitForBuild);
    }

    public static JoinOperatorType fullOuterJoin() {
        return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.FULL_OUTER, false, false);
    }

    private JoinOperatorType(LookupJoinOperatorFactory.JoinType type, boolean outputSingleMatch, boolean waitForBuild) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.outputSingleMatch = outputSingleMatch;
        this.waitForBuild = waitForBuild;
    }

    public boolean isOutputSingleMatch() {
        return this.outputSingleMatch;
    }

    public boolean isWaitForBuild() {
        return this.waitForBuild;
    }

    public LookupJoinOperatorFactory.JoinType getType() {
        return this.type;
    }
}

