/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHash;
import io.trino.operator.TransformWork;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.List;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(Session session, List<Type> types, boolean hasPrecomputedHash, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory updateMemory) {
        this.groupByHash = GroupByHash.createGroupByHash(session, types, hasPrecomputedHash, 10000, hashStrategyCompiler, updateMemory);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize();
    }

    public Work<Block> markDistinctRows(Page page) {
        return new TransformWork<int[], Block>(this.groupByHash.getGroupIds(page), groupIds -> this.processNextGroupIds(this.groupByHash.getGroupCount(), (int[])groupIds, page.getPositionCount()));
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    private Block processNextGroupIds(int groupCount, int[] ids, int positions) {
        if (positions > 1) {
            if (this.nextDistinctId == (long)groupCount) {
                return RunLengthEncodedBlock.create((Block)BooleanType.createBlockForSingleNonNullValue((boolean)false), (int)positions);
            }
            if (this.nextDistinctId + (long)positions == (long)groupCount) {
                this.nextDistinctId = groupCount;
                return RunLengthEncodedBlock.create((Block)BooleanType.createBlockForSingleNonNullValue((boolean)true), (int)positions);
            }
        }
        byte[] distinctMask = new byte[positions];
        for (int position = 0; position < distinctMask.length; ++position) {
            if ((long)ids[position] == this.nextDistinctId) {
                distinctMask[position] = 1;
                ++this.nextDistinctId;
                continue;
            }
            distinctMask[position] = 0;
        }
        Preconditions.checkState((this.nextDistinctId == (long)groupCount ? 1 : 0) != 0);
        return BooleanType.wrapByteArrayAsBooleanBlockWithoutNulls((byte[])distinctMask);
    }
}

