/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.CounterStat;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.TaskId;
import io.trino.memory.QueryContextVisitor;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.BlockedReason;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverStats;
import io.trino.operator.ExchangeOperator;
import io.trino.operator.OperatorStats;
import io.trino.operator.PipelineStats;
import io.trino.operator.PipelineStatus;
import io.trino.operator.TaskContext;
import io.trino.spi.metrics.Metrics;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@ThreadSafe
public class PipelineContext {
    private final TaskContext taskContext;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final int pipelineId;
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final boolean partitioned;
    private final List<DriverContext> drivers = new CopyOnWriteArrayList<DriverContext>();
    private final AtomicInteger totalSplits = new AtomicInteger();
    private final AtomicLong totalSplitsWeight = new AtomicLong();
    private final AtomicInteger completedDrivers = new AtomicInteger();
    private final AtomicLong completedSplitsWeight = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionEndTime = new AtomicReference();
    private final Distribution queuedTime = new Distribution();
    private final Distribution elapsedTime = new Distribution();
    private final AtomicLong totalScheduledTime = new AtomicLong();
    private final AtomicLong totalCpuTime = new AtomicLong();
    private final AtomicLong totalBlockedTime = new AtomicLong();
    private final CounterStat physicalInputDataSize = new CounterStat();
    private final CounterStat physicalInputPositions = new CounterStat();
    private final AtomicLong physicalInputReadTime = new AtomicLong();
    private final CounterStat internalNetworkInputDataSize = new CounterStat();
    private final CounterStat internalNetworkInputPositions = new CounterStat();
    private final CounterStat rawInputDataSize = new CounterStat();
    private final CounterStat rawInputPositions = new CounterStat();
    private final CounterStat processedInputDataSize = new CounterStat();
    private final CounterStat processedInputPositions = new CounterStat();
    private final AtomicLong inputBlockedTime = new AtomicLong();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicLong outputBlockedTime = new AtomicLong();
    private final AtomicLong physicalWrittenDataSize = new AtomicLong();
    private final ConcurrentMap<Integer, OperatorStats> operatorSummaries = new ConcurrentHashMap<Integer, OperatorStats>();
    private final ConcurrentMap<Integer, Metrics> pipelineOperatorMetrics = new ConcurrentHashMap<Integer, Metrics>();
    private final MemoryTrackingContext pipelineMemoryContext;

    public PipelineContext(int pipelineId, TaskContext taskContext, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, ScheduledExecutorService timeoutExecutor, MemoryTrackingContext pipelineMemoryContext, boolean inputPipeline, boolean outputPipeline, boolean partitioned) {
        this.pipelineId = pipelineId;
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        this.partitioned = partitioned;
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.pipelineMemoryContext = Objects.requireNonNull(pipelineMemoryContext, "pipelineMemoryContext is null");
        pipelineMemoryContext.initializeLocalMemoryContexts(ExchangeOperator.class.getSimpleName());
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public TaskId getTaskId() {
        return this.taskContext.getTaskId();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    public DriverContext addDriverContext() {
        return this.addDriverContext(0L);
    }

    public DriverContext addDriverContext(long splitWeight) {
        Preconditions.checkArgument((this.partitioned || splitWeight == 0L ? 1 : 0) != 0, (Object)"Only partitioned splits should have weights");
        DriverContext driverContext = new DriverContext(this, this.notificationExecutor, this.yieldExecutor, this.timeoutExecutor, this.pipelineMemoryContext.newMemoryTrackingContext(), splitWeight);
        this.drivers.add(driverContext);
        return driverContext;
    }

    public Session getSession() {
        return this.taskContext.getSession();
    }

    public void splitsAdded(int count, long weightSum) {
        Preconditions.checkArgument((count >= 0 && weightSum >= 0L ? 1 : 0) != 0);
        this.totalSplits.addAndGet(count);
        if (this.partitioned && weightSum != 0L) {
            this.totalSplitsWeight.addAndGet(weightSum);
        }
    }

    public void setPipelineOperatorMetrics(int operatorId, Metrics metrics) {
        this.pipelineOperatorMetrics.put(operatorId, metrics);
    }

    public void driverFinished(DriverContext driverContext) {
        Objects.requireNonNull(driverContext, "driverContext is null");
        if (!this.drivers.remove(driverContext)) {
            throw new IllegalArgumentException("Unknown driver " + String.valueOf(driverContext));
        }
        this.lastExecutionEndTime.set(DateTime.now());
        DriverStats driverStats = driverContext.getDriverStats();
        this.completedDrivers.getAndIncrement();
        if (this.partitioned) {
            this.completedSplitsWeight.addAndGet(driverContext.getSplitWeight());
        }
        this.queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
        this.elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalScheduledTime.getAndAdd(driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalCpuTime.getAndAdd(driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalBlockedTime.getAndAdd(driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS));
        List<OperatorStats> operators = driverStats.getOperatorStats();
        for (OperatorStats operator : operators) {
            Metrics pipelineLevelMetrics = this.pipelineOperatorMetrics.getOrDefault(operator.getOperatorId(), Metrics.EMPTY);
            this.operatorSummaries.merge(operator.getOperatorId(), operator, (first, second) -> first.addFillingPipelineMetrics((OperatorStats)second, pipelineLevelMetrics));
        }
        this.physicalInputDataSize.update(driverStats.getPhysicalInputDataSize().toBytes());
        this.physicalInputPositions.update(driverStats.getPhysicalInputPositions());
        this.physicalInputReadTime.getAndAdd(driverStats.getPhysicalInputReadTime().roundTo(TimeUnit.NANOSECONDS));
        this.internalNetworkInputDataSize.update(driverStats.getInternalNetworkInputDataSize().toBytes());
        this.internalNetworkInputPositions.update(driverStats.getInternalNetworkInputPositions());
        this.rawInputDataSize.update(driverStats.getRawInputDataSize().toBytes());
        this.rawInputPositions.update(driverStats.getRawInputPositions());
        this.processedInputDataSize.update(driverStats.getProcessedInputDataSize().toBytes());
        this.processedInputPositions.update(driverStats.getProcessedInputPositions());
        this.inputBlockedTime.getAndAdd(driverStats.getInputBlockedTime().roundTo(TimeUnit.NANOSECONDS));
        this.outputDataSize.update(driverStats.getOutputDataSize().toBytes());
        this.outputPositions.update(driverStats.getOutputPositions());
        this.outputBlockedTime.getAndAdd(driverStats.getOutputBlockedTime().roundTo(TimeUnit.NANOSECONDS));
        this.physicalWrittenDataSize.getAndAdd(driverStats.getPhysicalWrittenDataSize().toBytes());
    }

    public void start() {
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.lastExecutionStartTime.set(now);
        this.taskContext.start();
    }

    public void driverFailed(Throwable cause) {
        this.taskContext.failed(cause);
    }

    public boolean isTerminatingOrDone() {
        return this.taskContext.isTerminatingOrDone();
    }

    public synchronized ListenableFuture<Void> reserveSpill(long bytes) {
        return this.taskContext.reserveSpill(bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.taskContext.freeSpill(bytes);
    }

    public LocalMemoryContext localMemoryContext() {
        return this.pipelineMemoryContext.localUserMemoryContext();
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.taskContext.isPerOperatorCpuTimerEnabled();
    }

    public boolean isCpuTimerEnabled() {
        return this.taskContext.isCpuTimerEnabled();
    }

    public CounterStat getProcessedInputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.processedInputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.processedInputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputPositions());
        }
        return stat;
    }

    public long getWriterInputDataSize() {
        long writerInputDataSize = 0L;
        for (DriverContext context : this.drivers) {
            writerInputDataSize += context.getWriterInputDataSize();
        }
        return writerInputDataSize;
    }

    public long getPhysicalWrittenDataSize() {
        long physicalWrittenBytes = 0L;
        for (DriverContext context : this.drivers) {
            physicalWrittenBytes += context.getPhysicalWrittenDataSize();
        }
        return physicalWrittenBytes;
    }

    public PipelineStatus getPipelineStatus() {
        return PipelineContext.getPipelineStatus(this.drivers.iterator(), this.totalSplits.get(), this.completedDrivers.get(), this.getActivePartitionedSplitsWeight(), this.partitioned);
    }

    private long getActivePartitionedSplitsWeight() {
        if (this.partitioned) {
            return this.totalSplitsWeight.get() - this.completedSplitsWeight.get();
        }
        return 0L;
    }

    public PipelineStats getPipelineStats() {
        if (this.taskContext.getState().isDone()) {
            DateTime now = DateTime.now();
            this.executionStartTime.compareAndSet(null, now);
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.lastExecutionEndTime.compareAndSet(null, now);
        }
        int completedDrivers = this.completedDrivers.get();
        ImmutableList driverContexts = ImmutableList.copyOf(this.drivers);
        int totalSplits = this.totalSplits.get();
        PipelineStatusBuilder pipelineStatusBuilder = new PipelineStatusBuilder(totalSplits, completedDrivers, this.getActivePartitionedSplitsWeight(), this.partitioned);
        int totalDrivers = completedDrivers + driverContexts.size();
        Distribution queuedTime = this.queuedTime.duplicate();
        Distribution elapsedTime = this.elapsedTime.duplicate();
        long totalScheduledTime = this.totalScheduledTime.get();
        long totalCpuTime = this.totalCpuTime.get();
        long totalBlockedTime = this.totalBlockedTime.get();
        long physicalInputDataSize = this.physicalInputDataSize.getTotalCount();
        long physicalInputPositions = this.physicalInputPositions.getTotalCount();
        long internalNetworkInputDataSize = this.internalNetworkInputDataSize.getTotalCount();
        long internalNetworkInputPositions = this.internalNetworkInputPositions.getTotalCount();
        long rawInputDataSize = this.rawInputDataSize.getTotalCount();
        long rawInputPositions = this.rawInputPositions.getTotalCount();
        long processedInputDataSize = this.processedInputDataSize.getTotalCount();
        long processedInputPositions = this.processedInputPositions.getTotalCount();
        long physicalInputReadTime = this.physicalInputReadTime.get();
        long inputBlockedTime = this.inputBlockedTime.get();
        long outputDataSize = this.outputDataSize.getTotalCount();
        long outputPositions = this.outputPositions.getTotalCount();
        long outputBlockedTime = this.outputBlockedTime.get();
        long physicalWrittenDataSize = this.physicalWrittenDataSize.get();
        ImmutableSet.Builder blockedReasons = ImmutableSet.builder();
        boolean hasUnfinishedDrivers = false;
        boolean unfinishedDriversFullyBlocked = true;
        TreeMap<Integer, OperatorStats> operatorSummaries = new TreeMap<Integer, OperatorStats>(this.operatorSummaries);
        ArrayListMultimap runningOperators = ArrayListMultimap.create((int)operatorSummaries.size(), (int)driverContexts.size());
        ImmutableList.Builder drivers = ImmutableList.builderWithExpectedSize((int)driverContexts.size());
        for (Object driverContext : driverContexts) {
            DriverStats driverStats = ((DriverContext)driverContext).getDriverStats();
            drivers.add((Object)driverStats);
            pipelineStatusBuilder.accumulate(driverStats, ((DriverContext)driverContext).getSplitWeight());
            if (driverStats.getStartTime() != null && driverStats.getEndTime() == null) {
                hasUnfinishedDrivers = true;
                unfinishedDriversFullyBlocked &= driverStats.isFullyBlocked();
                blockedReasons.addAll(driverStats.getBlockedReasons());
            }
            queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
            elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
            totalScheduledTime += driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            for (OperatorStats operatorStats : driverStats.getOperatorStats()) {
                runningOperators.put((Object)operatorStats.getOperatorId(), (Object)operatorStats);
            }
            physicalInputDataSize += driverStats.getPhysicalInputDataSize().toBytes();
            physicalInputPositions += driverStats.getPhysicalInputPositions();
            physicalInputReadTime += driverStats.getPhysicalInputReadTime().roundTo(TimeUnit.NANOSECONDS);
            internalNetworkInputDataSize += driverStats.getInternalNetworkInputDataSize().toBytes();
            internalNetworkInputPositions += driverStats.getInternalNetworkInputPositions();
            rawInputDataSize += driverStats.getRawInputDataSize().toBytes();
            rawInputPositions += driverStats.getRawInputPositions();
            processedInputDataSize += driverStats.getProcessedInputDataSize().toBytes();
            processedInputPositions += driverStats.getProcessedInputPositions();
            inputBlockedTime += driverStats.getInputBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            outputDataSize += driverStats.getOutputDataSize().toBytes();
            outputPositions += driverStats.getOutputPositions();
            outputBlockedTime += driverStats.getOutputBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            physicalWrittenDataSize += driverStats.getPhysicalWrittenDataSize().toBytes();
        }
        BiFunction<Integer, OperatorStats, OperatorStats> combineOperatorStats = (arg_0, arg_1) -> this.lambda$getPipelineStats$1((ListMultimap)runningOperators, arg_0, arg_1);
        for (Integer operatorId : runningOperators.keySet()) {
            operatorSummaries.compute(operatorId, combineOperatorStats);
        }
        PipelineStatus pipelineStatus = pipelineStatusBuilder.build();
        boolean fullyBlocked = hasUnfinishedDrivers && unfinishedDriversFullyBlocked;
        return new PipelineStats(this.pipelineId, this.executionStartTime.get(), this.lastExecutionStartTime.get(), this.lastExecutionEndTime.get(), this.inputPipeline, this.outputPipeline, totalDrivers, pipelineStatus.getQueuedDrivers(), pipelineStatus.getQueuedPartitionedDrivers(), pipelineStatus.getQueuedPartitionedSplitsWeight(), pipelineStatus.getRunningDrivers(), pipelineStatus.getRunningPartitionedDrivers(), pipelineStatus.getRunningPartitionedSplitsWeight(), pipelineStatus.getBlockedDrivers(), completedDrivers, DataSize.succinctBytes((long)this.pipelineMemoryContext.getUserMemory()), DataSize.succinctBytes((long)this.pipelineMemoryContext.getRevocableMemory()), queuedTime.snapshot(), elapsedTime.snapshot(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, (Set<BlockedReason>)blockedReasons.build(), DataSize.succinctBytes((long)physicalInputDataSize), physicalInputPositions, new Duration((double)physicalInputReadTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)internalNetworkInputDataSize), internalNetworkInputPositions, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, new Duration((double)inputBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)outputDataSize), outputPositions, new Duration((double)outputBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)physicalWrittenDataSize), (List<OperatorStats>)ImmutableList.copyOf(operatorSummaries.values()), (List<DriverStats>)drivers.build());
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitPipelineContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.drivers.stream().map(driver -> driver.accept(visitor, context)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public MemoryTrackingContext getPipelineMemoryContext() {
        return this.pipelineMemoryContext;
    }

    private static PipelineStatus getPipelineStatus(Iterator<DriverContext> driverContextsIterator, int totalSplits, int completedDrivers, long activePartitionedSplitsWeight, boolean partitioned) {
        PipelineStatusBuilder builder = new PipelineStatusBuilder(totalSplits, completedDrivers, activePartitionedSplitsWeight, partitioned);
        while (driverContextsIterator.hasNext()) {
            builder.accumulate(driverContextsIterator.next());
        }
        return builder.build();
    }

    private /* synthetic */ OperatorStats lambda$getPipelineStats$1(ListMultimap runningOperators, Integer operatorId, OperatorStats current) {
        List runningStats = runningOperators.get((Object)operatorId);
        if (runningStats.isEmpty()) {
            return current;
        }
        Metrics pipelineLevelMetrics = this.pipelineOperatorMetrics.getOrDefault(operatorId, Metrics.EMPTY);
        if (current != null) {
            return current.addFillingPipelineMetrics(runningStats, pipelineLevelMetrics);
        }
        OperatorStats combined = (OperatorStats)runningStats.get(0);
        if (runningStats.size() > 1) {
            combined = combined.addFillingPipelineMetrics(runningStats.subList(1, runningStats.size()), pipelineLevelMetrics);
        } else if (pipelineLevelMetrics != Metrics.EMPTY) {
            combined = combined.withPipelineMetrics(pipelineLevelMetrics);
        }
        return combined;
    }

    private static final class PipelineStatusBuilder {
        private final int totalSplits;
        private final int completedDrivers;
        private final long activePartitionedSplitsWeight;
        private final boolean partitioned;
        private int runningDrivers;
        private int blockedDrivers;
        private long runningSplitsWeight;
        private long blockedSplitsWeight;
        private int physicallyQueuedDrivers;

        private PipelineStatusBuilder(int totalSplits, int completedDrivers, long activePartitionedSplitsWeight, boolean partitioned) {
            this.totalSplits = totalSplits;
            this.completedDrivers = completedDrivers;
            this.activePartitionedSplitsWeight = activePartitionedSplitsWeight;
            this.partitioned = partitioned;
        }

        public void accumulate(DriverContext driverContext) {
            if (!driverContext.isExecutionStarted()) {
                ++this.physicallyQueuedDrivers;
            } else if (driverContext.isFullyBlocked()) {
                ++this.blockedDrivers;
                this.blockedSplitsWeight += driverContext.getSplitWeight();
            } else {
                ++this.runningDrivers;
                this.runningSplitsWeight += driverContext.getSplitWeight();
            }
        }

        public void accumulate(DriverStats driverStats, long splitWeight) {
            if (driverStats.getStartTime() == null) {
                ++this.physicallyQueuedDrivers;
            } else if (driverStats.isFullyBlocked()) {
                ++this.blockedDrivers;
                this.blockedSplitsWeight += splitWeight;
            } else {
                ++this.runningDrivers;
                this.runningSplitsWeight += splitWeight;
            }
        }

        public PipelineStatus build() {
            long runningPartitionedSplitsWeight;
            int runningPartitionedSplits;
            int queuedPartitionedSplits;
            long queuedPartitionedSplitsWeight;
            int queuedDrivers;
            if (this.partitioned) {
                queuedDrivers = this.totalSplits - this.runningDrivers - this.blockedDrivers - this.completedDrivers;
                if (queuedDrivers < 0) {
                    queuedDrivers = 0;
                }
                queuedPartitionedSplitsWeight = this.activePartitionedSplitsWeight - this.runningSplitsWeight - this.blockedSplitsWeight;
                if (queuedDrivers == 0 || queuedPartitionedSplitsWeight < 0L) {
                    queuedPartitionedSplitsWeight = 0L;
                }
                queuedPartitionedSplits = queuedDrivers;
                runningPartitionedSplits = this.runningDrivers;
                runningPartitionedSplitsWeight = this.runningSplitsWeight;
            } else {
                queuedDrivers = this.physicallyQueuedDrivers;
                queuedPartitionedSplits = 0;
                queuedPartitionedSplitsWeight = 0L;
                runningPartitionedSplits = 0;
                runningPartitionedSplitsWeight = 0L;
            }
            return new PipelineStatus(queuedDrivers, this.runningDrivers, this.blockedDrivers, queuedPartitionedSplits, queuedPartitionedSplitsWeight, runningPartitionedSplits, runningPartitionedSplitsWeight);
        }
    }
}

