/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.GroupedTopNBuilder;
import io.trino.operator.GroupedTopNRowNumberBuilder;
import io.trino.operator.NoChannelGroupByHash;
import io.trino.operator.SimplePageWithPositionComparator;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TopNProcessor {
    private final LocalMemoryContext localUserMemoryContext;
    @Nullable
    private GroupedTopNBuilder topNBuilder;
    private Iterator<Page> outputIterator;

    public TopNProcessor(AggregatedMemoryContext aggregatedMemoryContext, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders, TypeOperators typeOperators) {
        Objects.requireNonNull(aggregatedMemoryContext, "aggregatedMemoryContext is null");
        this.localUserMemoryContext = aggregatedMemoryContext.newLocalMemoryContext(TopNProcessor.class.getSimpleName());
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be positive");
        if (n == 0) {
            this.outputIterator = Collections.emptyIterator();
        } else {
            this.topNBuilder = new GroupedTopNRowNumberBuilder(types, new SimplePageWithPositionComparator(types, sortChannels, sortOrders, typeOperators), n, false, new int[0], new NoChannelGroupByHash());
        }
    }

    public void addInput(Page page) {
        Objects.requireNonNull(this.topNBuilder, "topNBuilder is null");
        boolean done = this.topNBuilder.processPage(Objects.requireNonNull(page, "page is null")).process();
        Verify.verify((boolean)done);
        this.updateMemoryReservation();
    }

    public Page getOutput() {
        if (this.outputIterator == null) {
            this.outputIterator = this.topNBuilder.buildResult();
        }
        Page output = null;
        if (this.outputIterator.hasNext()) {
            output = this.outputIterator.next();
        } else {
            this.outputIterator = Collections.emptyIterator();
        }
        this.updateMemoryReservation();
        return output;
    }

    public boolean noMoreOutput() {
        return this.outputIterator != null && !this.outputIterator.hasNext();
    }

    private void updateMemoryReservation() {
        Objects.requireNonNull(this.topNBuilder, "topNBuilder is null");
        this.localUserMemoryContext.setBytes(this.topNBuilder.getEstimatedSizeInBytes());
    }
}

