/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AggregationFunctionAdapter {
    private static final MethodHandle BOOLEAN_TYPE_GETTER;
    private static final MethodHandle LONG_TYPE_GETTER;
    private static final MethodHandle DOUBLE_TYPE_GETTER;
    private static final MethodHandle OBJECT_TYPE_GETTER;

    private AggregationFunctionAdapter() {
    }

    public static MethodHandle normalizeInputMethod(MethodHandle inputMethod, BoundSignature boundSignature, AggregationParameterKind ... parameterKinds) {
        return AggregationFunctionAdapter.normalizeInputMethod(inputMethod, boundSignature, (List<AggregationParameterKind>)ImmutableList.copyOf((Object[])parameterKinds));
    }

    public static MethodHandle normalizeInputMethod(MethodHandle inputMethod, BoundSignature boundSignature, List<AggregationParameterKind> parameterKinds) {
        return AggregationFunctionAdapter.normalizeInputMethod(inputMethod, boundSignature, parameterKinds, 0);
    }

    public static MethodHandle normalizeInputMethod(MethodHandle inputMethod, BoundSignature boundSignature, List<AggregationParameterKind> parameterKinds, int lambdaCount) {
        Objects.requireNonNull(inputMethod, "inputMethod is null");
        Objects.requireNonNull(parameterKinds, "parameterKinds is null");
        Objects.requireNonNull(boundSignature, "boundSignature is null");
        Preconditions.checkArgument((inputMethod.type().parameterCount() - lambdaCount == parameterKinds.size() ? 1 : 0) != 0, (String)"Input method has %s parameters, but parameter kinds only has %s items", (int)(inputMethod.type().parameterCount() - lambdaCount), (int)parameterKinds.size());
        List stateArgumentKinds = (List)parameterKinds.stream().filter(AggregationParameterKind.STATE::equals).collect(ImmutableList.toImmutableList());
        List inputArgumentKinds = (List)parameterKinds.stream().filter(kind -> kind == AggregationParameterKind.INPUT_CHANNEL || kind == AggregationParameterKind.BLOCK_INPUT_CHANNEL || kind == AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boundSignature.getArgumentTypes().size() - lambdaCount == inputArgumentKinds.size() ? 1 : 0) != 0, (String)"Bound signature has %s arguments, but parameter kinds only has %s input arguments", (int)(boundSignature.getArgumentTypes().size() - lambdaCount), (int)inputArgumentKinds.size());
        ArrayList<AggregationParameterKind> expectedInputArgumentKinds = new ArrayList<AggregationParameterKind>();
        expectedInputArgumentKinds.addAll(stateArgumentKinds);
        for (AggregationParameterKind kind2 : inputArgumentKinds) {
            expectedInputArgumentKinds.add(kind2);
            if (kind2 != AggregationParameterKind.BLOCK_INPUT_CHANNEL && kind2 != AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL) continue;
            expectedInputArgumentKinds.add(AggregationParameterKind.BLOCK_INDEX);
        }
        Preconditions.checkArgument((boolean)expectedInputArgumentKinds.equals(parameterKinds), (String)"Expected input parameter kinds %s, but got %s", expectedInputArgumentKinds, parameterKinds);
        for (int argumentIndex = 0; argumentIndex < inputArgumentKinds.size(); ++argumentIndex) {
            MethodHandle valueGetter;
            int parameterIndex = stateArgumentKinds.size() + argumentIndex * 2;
            AggregationParameterKind inputArgument = (AggregationParameterKind)((Object)inputArgumentKinds.get(argumentIndex));
            if (inputArgument != AggregationParameterKind.INPUT_CHANNEL) {
                if (inputArgument != AggregationParameterKind.BLOCK_INPUT_CHANNEL && inputArgument != AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL) continue;
                Preconditions.checkArgument((boolean)ValueBlock.class.isAssignableFrom((Class<?>)inputMethod.type().parameterType(parameterIndex)), (String)"Expected parameter %s to be a ValueBlock", (int)parameterIndex);
                continue;
            }
            Type argumentType = boundSignature.getArgumentType(argumentIndex);
            if (argumentType.getJavaType().equals(Boolean.TYPE)) {
                valueGetter = BOOLEAN_TYPE_GETTER.bindTo(argumentType);
            } else if (argumentType.getJavaType().equals(Long.TYPE)) {
                valueGetter = LONG_TYPE_GETTER.bindTo(argumentType);
            } else if (argumentType.getJavaType().equals(Double.TYPE)) {
                valueGetter = DOUBLE_TYPE_GETTER.bindTo(argumentType);
            } else {
                valueGetter = OBJECT_TYPE_GETTER.bindTo(argumentType);
                valueGetter = valueGetter.asType(valueGetter.type().changeReturnType((Class<?>)inputMethod.type().parameterType(parameterIndex)));
            }
            inputMethod = MethodHandles.collectArguments(inputMethod, parameterIndex, valueGetter);
        }
        return inputMethod;
    }

    static {
        try {
            BOOLEAN_TYPE_GETTER = MethodHandles.lookup().findVirtual(Type.class, "getBoolean", MethodType.methodType(Boolean.TYPE, Block.class, Integer.TYPE)).asType(MethodType.methodType(Boolean.TYPE, Type.class, ValueBlock.class, Integer.TYPE));
            LONG_TYPE_GETTER = MethodHandles.lookup().findVirtual(Type.class, "getLong", MethodType.methodType(Long.TYPE, Block.class, Integer.TYPE)).asType(MethodType.methodType(Long.TYPE, Type.class, ValueBlock.class, Integer.TYPE));
            DOUBLE_TYPE_GETTER = MethodHandles.lookup().findVirtual(Type.class, "getDouble", MethodType.methodType(Double.TYPE, Block.class, Integer.TYPE)).asType(MethodType.methodType(Double.TYPE, Type.class, ValueBlock.class, Integer.TYPE));
            OBJECT_TYPE_GETTER = MethodHandles.lookup().findVirtual(Type.class, "getObject", MethodType.methodType(Object.class, Block.class, Integer.TYPE)).asType(MethodType.methodType(Object.class, Type.class, ValueBlock.class, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum AggregationParameterKind {
        INPUT_CHANNEL,
        BLOCK_INPUT_CHANNEL,
        NULLABLE_BLOCK_INPUT_CHANNEL,
        BLOCK_INDEX,
        STATE;

    }
}

