/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;

@AggregationFunction(value="bitwise_xor_agg")
public final class BitwiseXorAggregation {
    private BitwiseXorAggregation() {
    }

    @InputFunction
    public static void bitXor(@AggregationState NullableLongState state, @SqlType(value="bigint") long value) {
        if (state.isNull()) {
            state.setValue(value);
        } else {
            state.setValue(state.getValue() ^ value);
        }
        state.setNull(false);
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        if (state.isNull()) {
            state.set(otherState);
        } else if (!otherState.isNull()) {
            state.setValue(state.getValue() ^ otherState.getValue());
        }
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }
}

