/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="count", windowAccumulator=CountColumnWindowAccumulator.class)
@Description(value="Counts the non-null values")
public final class CountColumn {
    private CountColumn() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState LongState state, @BlockPosition @SqlType(value="T") ValueBlock block, @BlockIndex int position) {
        state.setValue(state.getValue() + 1L);
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, LongState otherState) {
        state.setValue(state.getValue() + otherState.getValue());
    }

    @OutputFunction(value="BIGINT")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getValue());
    }

    public static class CountColumnWindowAccumulator
    implements WindowAccumulator {
        private long count;

        @UsedByGeneratedCode
        public CountColumnWindowAccumulator() {
        }

        private CountColumnWindowAccumulator(long count) {
            this.count = count;
        }

        public long getEstimatedSize() {
            return 8L;
        }

        public WindowAccumulator copy() {
            return new CountColumnWindowAccumulator(this.count);
        }

        public void addInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                ++this.count;
            }
        }

        public boolean removeInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                --this.count;
            }
            return true;
        }

        public void output(BlockBuilder blockBuilder) {
            BigintType.BIGINT.writeLong(blockBuilder, this.count);
        }
    }
}

