/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.DoubleState;
import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.RealType;
import io.trino.type.Reals;

@AggregationFunction(value="avg", windowAccumulator=RealAverageWindowAccumulator.class)
@Description(value="Returns the average value of the argument")
public final class RealAverageAggregation {
    private RealAverageAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongState count, @AggregationState DoubleState sum, @SqlType(value="REAL") long value) {
        count.setValue(count.getValue() + 1L);
        sum.setValue(sum.getValue() + (double)Float.intBitsToFloat((int)value));
    }

    @CombineFunction
    public static void combine(@AggregationState LongState count, @AggregationState DoubleState sum, @AggregationState LongState otherCount, @AggregationState DoubleState otherSum) {
        count.setValue(count.getValue() + otherCount.getValue());
        sum.setValue(sum.getValue() + otherSum.getValue());
    }

    @OutputFunction(value="REAL")
    public static void output(@AggregationState LongState count, @AggregationState DoubleState sum, BlockBuilder out) {
        if (count.getValue() == 0L) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, Reals.toReal((float)(sum.getValue() / (double)count.getValue())));
        }
    }

    public static class RealAverageWindowAccumulator
    implements WindowAccumulator {
        private long count;
        private double sum;

        @UsedByGeneratedCode
        public RealAverageWindowAccumulator() {
        }

        private RealAverageWindowAccumulator(long count, double sum) {
            this.count = count;
            this.sum = sum;
        }

        public long getEstimatedSize() {
            return 16L;
        }

        public WindowAccumulator copy() {
            return new RealAverageWindowAccumulator(this.count, this.sum);
        }

        public void addInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum += (double)Float.intBitsToFloat((int)index.getLong(0, i));
                ++this.count;
            }
        }

        public boolean removeInput(WindowIndex index, int startPosition, int endPosition) {
            if (!Double.isFinite(this.sum)) {
                return false;
            }
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum -= (double)Float.intBitsToFloat((int)index.getLong(0, i));
                --this.count;
            }
            return true;
        }

        public void output(BlockBuilder blockBuilder) {
            if (this.count == 0L) {
                blockBuilder.appendNull();
            } else {
                RealType.REAL.writeLong(blockBuilder, Reals.toReal((float)(this.sum / (double)this.count)));
            }
        }
    }
}

