/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.partial;

import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.OptionalLong;

public class PartialAggregationController {
    private static final double DISABLE_AGGREGATION_BUFFER_SIZE_TO_INPUT_BYTES_FACTOR = 1.5;
    private static final double ENABLE_AGGREGATION_BUFFER_SIZE_TO_INPUT_BYTES_FACTOR = 300.0;
    private final DataSize maxPartialMemory;
    private final double uniqueRowsRatioThreshold;
    private volatile boolean partialAggregationDisabled;
    private long totalBytesProcessed;
    private long totalRowProcessed;
    private long totalUniqueRowsProduced;

    public PartialAggregationController(DataSize maxPartialMemory, double uniqueRowsRatioThreshold) {
        this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
        this.uniqueRowsRatioThreshold = uniqueRowsRatioThreshold;
    }

    public boolean isPartialAggregationDisabled() {
        return this.partialAggregationDisabled;
    }

    public synchronized void onFlush(long bytesProcessed, long rowsProcessed, OptionalLong uniqueRowsProduced) {
        if (!this.partialAggregationDisabled && uniqueRowsProduced.isEmpty()) {
            return;
        }
        this.totalBytesProcessed += bytesProcessed;
        this.totalRowProcessed += rowsProcessed;
        uniqueRowsProduced.ifPresent(value -> this.totalUniqueRowsProduced += value);
        if (!this.partialAggregationDisabled && this.shouldDisablePartialAggregation()) {
            this.partialAggregationDisabled = true;
        }
        if (this.partialAggregationDisabled && (double)this.totalBytesProcessed >= (double)this.maxPartialMemory.toBytes() * 300.0) {
            this.totalBytesProcessed = 0L;
            this.totalRowProcessed = 0L;
            this.totalUniqueRowsProduced = 0L;
            this.partialAggregationDisabled = false;
        }
    }

    private boolean shouldDisablePartialAggregation() {
        return (double)this.totalBytesProcessed >= (double)this.maxPartialMemory.toBytes() * 1.5 && (double)this.totalUniqueRowsProduced / (double)this.totalRowProcessed > this.uniqueRowsRatioThreshold;
    }

    public PartialAggregationController duplicate() {
        return new PartialAggregationController(this.maxPartialMemory, this.uniqueRowsRatioThreshold);
    }
}

