/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.airlift.stats.QuantileDigest;
import io.trino.array.DoubleBigArray;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.QuantileDigestAndPercentileState;
import io.trino.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class QuantileDigestAndPercentileStateFactory
implements AccumulatorStateFactory<QuantileDigestAndPercentileState> {
    public QuantileDigestAndPercentileState createSingleState() {
        return new SingleQuantileDigestAndPercentileState();
    }

    public QuantileDigestAndPercentileState createGroupedState() {
        return new GroupedQuantileDigestAndPercentileState();
    }

    public static class SingleQuantileDigestAndPercentileState
    implements QuantileDigestAndPercentileState {
        public static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleQuantileDigestAndPercentileState.class);
        private QuantileDigest digest;
        private double percentile;

        @Override
        public QuantileDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            this.digest = digest;
        }

        @Override
        public double getPercentile() {
            return this.percentile;
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentile = percentile;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.digest != null) {
                estimatedSize += (long)this.digest.estimatedInMemorySizeInBytes();
            }
            return estimatedSize;
        }
    }

    public static class GroupedQuantileDigestAndPercentileState
    extends AbstractGroupedAccumulatorState
    implements QuantileDigestAndPercentileState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedQuantileDigestAndPercentileState.class);
        private final ObjectBigArray<QuantileDigest> digests = new ObjectBigArray();
        private final DoubleBigArray percentiles = new DoubleBigArray();
        private long size;

        public void ensureCapacity(int size) {
            this.digests.ensureCapacity((long)size);
            this.percentiles.ensureCapacity((long)size);
        }

        @Override
        public QuantileDigest getDigest() {
            return (QuantileDigest)this.digests.get((long)this.getGroupId());
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            Objects.requireNonNull(digest, "digest is null");
            this.digests.set((long)this.getGroupId(), (Object)digest);
        }

        @Override
        public double getPercentile() {
            return this.percentiles.get((long)this.getGroupId());
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentiles.set((long)this.getGroupId(), percentile);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.digests.sizeOf() + this.percentiles.sizeOf();
        }
    }
}

