/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

final class PositionsAppenderUtil {
    private static final double BLOCK_RESET_SKEW = 1.25;
    private static final int DEFAULT_CAPACITY = 64;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private PositionsAppenderUtil() {
    }

    static int calculateNewArraySize(int currentSize) {
        long newSize = (long)currentSize + (long)(currentSize >> 1);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L && (newSize = 0x7FFFFFF7L) == (long)currentSize) {
            throw new IllegalArgumentException(String.format("Cannot grow array beyond '%s'", 0x7FFFFFF7));
        }
        return (int)newSize;
    }

    static int calculateBlockResetSize(int currentSize) {
        long newSize = (long)Math.ceil((double)currentSize * 1.25);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L) {
            newSize = 0x7FFFFFF7L;
        }
        return (int)newSize;
    }
}

