/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="element_at")
@Description(value="Get element of array at given index")
public final class ArrayElementAtFunction {
    private ArrayElementAtFunction() {
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Object elementAt(@TypeParameter(value="E") Type elementType, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle readValue, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) throws Throwable {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return readValue.invoke(array, position);
    }

    private static int checkedIndexToBlockPosition(Block block, long index) {
        int arrayLength = block.getPositionCount();
        if (index == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (Math.abs(index) > (long)arrayLength) {
            return -1;
        }
        if (index > 0L) {
            return Math.toIntExact(index - 1L);
        }
        return Math.toIntExact((long)arrayLength + index);
    }
}

