/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.ArrayAnyMatchFunction;
import io.trino.operator.scalar.ObjectToBooleanFunction;
import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

@Description(value="Returns true if all elements of the array don't match the given predicate")
@ScalarFunction(value="none_match")
public final class ArrayNoneMatchFunction {
    private ArrayNoneMatchFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatch(@OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle readValue, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") ObjectToBooleanFunction function) throws Throwable {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatch(readValue, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }
}

