/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.lambda.LambdaFunctionInterface;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.Comparator;
import java.util.List;

@ScalarFunction(value="array_sort")
@Description(value="Sorts the given array with a lambda comparator.")
public final class ArraySortComparatorFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder;
    private static final int INITIAL_LENGTH = 128;
    private List<Integer> positions = Ints.asList((int[])new int[128]);

    @TypeParameter(value="T")
    public ArraySortComparatorFunction(@TypeParameter(value="T") Type elementType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType(elementType));
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public Block sort(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle readValue, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, integer)") ComparatorObjectLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        Comparator comparator = (x, y) -> {
            try {
                return ArraySortComparatorFunction.comparatorResult(function.apply(block.isNull(x.intValue()) ? null : readValue.invoke(block, (Integer)x), block.isNull(y.intValue()) ? null : readValue.invoke(block, (Integer)y)));
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
        this.sortPositions(arrayLength, comparator);
        return this.arrayValueBuilder.build(arrayLength, elementBuilder -> {
            for (int i = 0; i < arrayLength; ++i) {
                type.appendTo(block, this.positions.get(i).intValue(), elementBuilder);
            }
        });
    }

    private void initPositionsList(int arrayLength) {
        if (this.positions.size() < arrayLength) {
            this.positions = Ints.asList((int[])new int[arrayLength]);
        }
        for (int i = 0; i < arrayLength; ++i) {
            this.positions.set(i, i);
        }
    }

    private void sortPositions(int arrayLength, Comparator<Integer> comparator) {
        List<Integer> list = this.positions.subList(0, arrayLength);
        try {
            list.sort(comparator);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator violates the comparator contract", (Throwable)e);
        }
    }

    private static int comparatorResult(Long result) {
        Failures.checkCondition(result != null && (result == -1L || result == 0L || result == 1L), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator must return either -1, 0, or 1", new Object[0]);
        return result.intValue();
    }

    @FunctionalInterface
    public static interface ComparatorObjectLambda
    extends LambdaFunctionInterface {
        public Long apply(Object var1, Object var2);
    }
}

