/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Supplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;

@ScalarFunction(value="trim_array")
@Description(value="Remove elements from the end of array")
public final class ArrayTrimFunction {
    private ArrayTrimFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block trim(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long size) {
        Failures.checkCondition(size >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Supplier<String>)((Supplier)() -> String.format("size must not be negative: %s", size)));
        Failures.checkCondition(size <= (long)array.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Supplier<String>)((Supplier)() -> String.format("size must not exceed array cardinality %s: %s", array.getPositionCount(), size)));
        return array.getRegion(0, Math.toIntExact((long)array.getPositionCount() - size));
    }
}

