/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.UnknownType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class CastFromUnknownOperator
extends SqlScalarFunction {
    public static final CastFromUnknownOperator CAST_FROM_UNKNOWN = new CastFromUnknownOperator();
    private static final MethodHandle METHOD_HANDLE_NON_NULL = Reflection.methodHandle(CastFromUnknownOperator.class, "handleNonNull", Boolean.TYPE);

    public CastFromUnknownOperator() {
        super(FunctionMetadata.operatorBuilder((OperatorType)OperatorType.CAST).signature(Signature.builder().typeVariable("E").returnType(new TypeSignature("E", new TypeSignatureParameter[0])).argumentType((Type)UnknownType.UNKNOWN).build()).build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type toType = boundSignature.getReturnType();
        MethodHandle methodHandle = METHOD_HANDLE_NON_NULL.asType(METHOD_HANDLE_NON_NULL.type().changeReturnType(toType.getJavaType()));
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Object handleNonNull(boolean arg) {
        throw new IllegalArgumentException("value of unknown type should always be null");
    }
}

