/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexComparator;
import io.trino.operator.WindowOperator;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Partitioner;
import io.trino.operator.window.PatternRecognitionPartition;
import io.trino.operator.window.WindowPartition;
import io.trino.operator.window.matcher.Matcher;
import io.trino.operator.window.pattern.ArgumentComputation;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.operator.window.pattern.LogicalIndexNavigation;
import io.trino.operator.window.pattern.MatchAggregation;
import io.trino.operator.window.pattern.MeasureComputation;
import io.trino.spi.function.WindowFunction;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PatternRecognitionPartitioner
implements Partitioner {
    private final List<MeasureComputation> measures;
    private final List<MatchAggregation> measureAggregations;
    private final List<ArgumentComputation> measureComputationsAggregationArguments;
    private final Optional<FrameInfo> commonBaseFrame;
    private final RowsPerMatch rowsPerMatch;
    private final Optional<LogicalIndexNavigation> skipToNavigation;
    private final SkipToPosition skipToPosition;
    private final boolean initial;
    private final Matcher matcher;
    private final List<LabelEvaluator.Evaluation> labelEvaluations;
    private final List<ArgumentComputation> labelEvaluationsAggregationArguments;
    private final List<String> labelNames;

    public PatternRecognitionPartitioner(List<MeasureComputation> measures, List<MatchAggregation> measureAggregations, List<ArgumentComputation> measureComputationsAggregationArguments, Optional<FrameInfo> commonBaseFrame, RowsPerMatch rowsPerMatch, Optional<LogicalIndexNavigation> skipToNavigation, SkipToPosition skipToPosition, boolean initial, Matcher matcher, List<LabelEvaluator.Evaluation> labelEvaluations, List<ArgumentComputation> labelEvaluationsAggregationArguments, List<String> labelNames) {
        Objects.requireNonNull(measures, "measures is null");
        Objects.requireNonNull(measureAggregations, "measureAggregations is null");
        Objects.requireNonNull(measureComputationsAggregationArguments, "measureComputationsAggregationArguments is null");
        Objects.requireNonNull(commonBaseFrame, "commonBaseFrame is null");
        Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        Objects.requireNonNull(skipToNavigation, "skipToNavigation is null");
        Objects.requireNonNull(skipToPosition, "skipToPosition is null");
        Objects.requireNonNull(matcher, "matcher is null");
        Objects.requireNonNull(labelEvaluations, "labelEvaluations is null");
        Objects.requireNonNull(labelEvaluationsAggregationArguments, "labelEvaluationsAggregationArguments is null");
        Objects.requireNonNull(labelNames, "labelNames is null");
        this.measures = measures;
        this.measureAggregations = measureAggregations;
        this.measureComputationsAggregationArguments = measureComputationsAggregationArguments;
        this.commonBaseFrame = commonBaseFrame;
        this.rowsPerMatch = rowsPerMatch;
        this.skipToNavigation = skipToNavigation;
        this.skipToPosition = skipToPosition;
        this.initial = initial;
        this.matcher = matcher;
        this.labelEvaluations = labelEvaluations;
        this.labelEvaluationsAggregationArguments = labelEvaluationsAggregationArguments;
        this.labelNames = labelNames;
    }

    @Override
    public WindowPartition createPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, int[] outputChannels, List<WindowFunction> windowFunctions, List<FrameInfo> frames, PagesHashStrategy peerGroupHashStrategy, Map<WindowOperator.FrameBoundKey, PagesIndexComparator> frameBoundComparators, AggregatedMemoryContext memoryContext) {
        return new PatternRecognitionPartition(pagesIndex, partitionStart, partitionEnd, outputChannels, windowFunctions, peerGroupHashStrategy, memoryContext, this.measures, this.measureAggregations, this.measureComputationsAggregationArguments, this.commonBaseFrame, this.rowsPerMatch, this.skipToNavigation, this.skipToPosition, this.initial, this.matcher, this.labelEvaluations, this.labelEvaluationsAggregationArguments, this.labelNames);
    }
}

