/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.trino.server.DisableHttpCache;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.reflect.Method;

public class DisableHttpCacheDynamicFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (DisableHttpCacheDynamicFeature.isCacheDisabled(resourceInfo.getResourceClass()) || DisableHttpCacheDynamicFeature.isCacheDisabled(resourceInfo.getResourceMethod())) {
            context.register((Object)new DisableCacheResponseFilter());
        }
    }

    private static boolean isCacheDisabled(Class<?> clazz) {
        return clazz.getAnnotation(DisableHttpCache.class) != null;
    }

    private static boolean isCacheDisabled(Method method) {
        return method.getAnnotation(DisableHttpCache.class) != null;
    }

    private static class DisableCacheResponseFilter
    implements ContainerResponseFilter {
        private DisableCacheResponseFilter() {
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
            responseContext.getHeaders().add((Object)"X-Download-Options", (Object)"noopen");
            responseContext.getHeaders().add((Object)"Cache-Control", (Object)"no-cache, no-store, max-age=0");
            responseContext.getHeaders().add((Object)"Pragma", (Object)"no-cache");
            responseContext.getHeaders().add((Object)"Expires", (Object)"0");
        }
    }
}

