/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.trino.server.InternalAuthenticationManager;
import io.trino.server.InternalCommunicationConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class InternalCommunicationHttpClientModule
extends AbstractConfigurationAwareModule {
    private final String clientName;
    private final Class<? extends Annotation> annotation;
    private final Consumer<HttpClientConfig> configDefaults;
    private final List<Class<? extends HttpRequestFilter>> filters;

    private InternalCommunicationHttpClientModule(String clientName, Class<? extends Annotation> annotation, Consumer<HttpClientConfig> configDefaults, List<Class<? extends HttpRequestFilter>> filters) {
        this.clientName = Objects.requireNonNull(clientName, "clientName is null");
        this.annotation = Objects.requireNonNull(annotation, "annotation is null");
        this.configDefaults = Objects.requireNonNull(configDefaults, "configDefaults is null");
        this.filters = ImmutableList.copyOf((Collection)Objects.requireNonNull(filters, "filters is null"));
    }

    protected void setup(Binder binder) {
        HttpClientBinder.HttpClientBindingBuilder httpClientBindingBuilder = HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient(this.clientName, this.annotation);
        InternalCommunicationConfig internalCommunicationConfig = (InternalCommunicationConfig)this.buildConfigObject(InternalCommunicationConfig.class);
        httpClientBindingBuilder.withConfigDefaults(httpConfig -> {
            InternalCommunicationHttpClientModule.configureClient(httpConfig, internalCommunicationConfig);
            this.configDefaults.accept((HttpClientConfig)httpConfig);
        });
        httpClientBindingBuilder.addFilterBinding().to(InternalAuthenticationManager.class);
        this.filters.forEach(arg_0 -> ((HttpClientBinder.HttpClientBindingBuilder)httpClientBindingBuilder).withFilter(arg_0));
    }

    static void configureClient(HttpClientConfig httpConfig, InternalCommunicationConfig internalCommunicationConfig) {
        httpConfig.setHttp2Enabled(internalCommunicationConfig.isHttp2Enabled());
        if (internalCommunicationConfig.isHttpsRequired() && internalCommunicationConfig.getKeyStorePath() == null && internalCommunicationConfig.getTrustStorePath() == null) {
            InternalCommunicationHttpClientModule.configureClientForAutomaticHttps(httpConfig, internalCommunicationConfig);
        } else {
            InternalCommunicationHttpClientModule.configureClientForManualHttps(httpConfig, internalCommunicationConfig);
        }
    }

    private static void configureClientForAutomaticHttps(HttpClientConfig httpConfig, InternalCommunicationConfig internalCommunicationConfig) {
        String sharedSecret = internalCommunicationConfig.getSharedSecret().orElseThrow(() -> new IllegalArgumentException("Internal shared secret must be set when internal HTTPS is enabled"));
        httpConfig.setAutomaticHttpsSharedSecret(sharedSecret);
    }

    private static void configureClientForManualHttps(HttpClientConfig httpConfig, InternalCommunicationConfig internalCommunicationConfig) {
        httpConfig.setKeyStorePath(internalCommunicationConfig.getKeyStorePath());
        httpConfig.setKeyStorePassword(internalCommunicationConfig.getKeyStorePassword());
        httpConfig.setTrustStorePath(internalCommunicationConfig.getTrustStorePath());
        httpConfig.setTrustStorePassword(internalCommunicationConfig.getTrustStorePassword());
        httpConfig.setAutomaticHttpsSharedSecret(null);
    }

    public static Builder internalHttpClientModule(String clientName, Class<? extends Annotation> annotation) {
        return new Builder(clientName, annotation);
    }

    public static class Builder {
        private final String clientName;
        private final Class<? extends Annotation> annotation;
        private Consumer<HttpClientConfig> configDefaults = config -> {};
        private final List<Class<? extends HttpRequestFilter>> filters = new ArrayList<Class<? extends HttpRequestFilter>>();

        private Builder(String clientName, Class<? extends Annotation> annotation) {
            this.clientName = Objects.requireNonNull(clientName, "clientName is null");
            this.annotation = Objects.requireNonNull(annotation, "annotation is null");
        }

        public Builder withConfigDefaults(Consumer<HttpClientConfig> configDefaults) {
            this.configDefaults = Objects.requireNonNull(configDefaults, "configDefaults is null");
            return this;
        }

        public Builder withFilter(Class<? extends HttpRequestFilter> requestFilter) {
            this.filters.add(requestFilter);
            return this;
        }

        public InternalCommunicationHttpClientModule build() {
            return new InternalCommunicationHttpClientModule(this.clientName, this.annotation, this.configDefaults, this.filters);
        }
    }
}

