/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.server.ExternalUriInfo;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.HostAddress;
import io.trino.spi.protocol.SpooledLocation;
import io.trino.spi.protocol.SpooledSegmentHandle;
import io.trino.spi.protocol.SpoolingManager;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

@Path(value="/v1/spooled/segments/{identifier}")
@ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
public class SegmentResource {
    private final SpoolingManager spoolingManager;
    private final boolean useWorkers;
    private final InternalNodeManager nodeManager;
    private final AtomicInteger nextWorkerIndex = new AtomicInteger();

    @Inject
    public SegmentResource(SpoolingManager spoolingManager, SpoolingConfig config, InternalNodeManager nodeManager) {
        this.spoolingManager = Objects.requireNonNull(spoolingManager, "spoolingManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.useWorkers = config.isUseWorkers() && nodeManager.getCurrentNode().isCoordinator();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    public Response download(@Context UriInfo uriInfo, @PathParam(value="identifier") String identifier, @Context HttpHeaders headers) throws IOException {
        SpooledSegmentHandle handle = this.handle(identifier, headers);
        Optional directLocation = this.spoolingManager.directLocation(handle);
        if (directLocation.isPresent()) {
            return Response.seeOther((URI)((SpooledLocation.DirectLocation)directLocation.get()).uri()).build();
        }
        if (this.useWorkers) {
            HostAddress hostAddress = this.nextActiveNode();
            return Response.seeOther((URI)uriInfo.getRequestUriBuilder().host(hostAddress.getHostText()).port(hostAddress.getPort()).build(new Object[0])).build();
        }
        return Response.ok((Object)this.spoolingManager.openInputStream(handle)).build();
    }

    @DELETE
    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    public Response acknowledge(@PathParam(value="identifier") String identifier, @Context HttpHeaders headers) throws IOException {
        try {
            this.spoolingManager.acknowledge(this.handle(identifier, headers));
            return Response.ok().build();
        }
        catch (IOException e) {
            return Response.serverError().entity((Object)e.toString()).build();
        }
    }

    public static UriBuilder spooledSegmentUriBuilder(ExternalUriInfo info) {
        return UriBuilder.fromUri((URI)info.baseUriBuilder().build()).path(SegmentResource.class);
    }

    public HostAddress nextActiveNode() {
        ImmutableList internalNodes = ImmutableList.copyOf(this.nodeManager.getActiveNodesSnapshot().getAllNodes());
        Verify.verify((!internalNodes.isEmpty() ? 1 : 0) != 0, (String)"No active nodes available", (Object[])new Object[0]);
        return ((InternalNode)internalNodes.get(Math.floorDiv(this.nextWorkerIndex.incrementAndGet(), internalNodes.size()))).getHostAndPort();
    }

    private SpooledSegmentHandle handle(String identifier, HttpHeaders headers) {
        return this.spoolingManager.handle((SpooledLocation)SpooledLocation.coordinatorLocation((Slice)Slices.wrappedBuffer((byte[])identifier.getBytes(StandardCharsets.UTF_8)), (Map)headers.getRequestHeaders()));
    }
}

