/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.DataSize;
import io.trino.util.Ciphers;
import jakarta.validation.constraints.AssertTrue;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SpoolingConfig {
    private boolean useWorkers;
    private boolean directStorageAccess = true;
    private boolean directStorageFallback;
    private boolean inlineSegments = true;
    private DataSize initialSegmentSize = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maximumSegmentSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private Optional<SecretKey> sharedEncryptionKey = Optional.empty();

    public boolean isUseWorkers() {
        return this.useWorkers;
    }

    @Config(value="protocol.spooling.worker-access")
    @ConfigDescription(value="Use worker nodes to retrieve data from spooling location")
    public SpoolingConfig setUseWorkers(boolean useWorkers) {
        this.useWorkers = useWorkers;
        return this;
    }

    public boolean isDirectStorageAccess() {
        return this.directStorageAccess;
    }

    @Config(value="protocol.spooling.direct-storage-access")
    @ConfigDescription(value="Retrieve segments directly from the spooling location")
    public SpoolingConfig setDirectStorageAccess(boolean directStorageAccess) {
        this.directStorageAccess = directStorageAccess;
        return this;
    }

    public boolean isDirectStorageFallback() {
        return this.directStorageFallback;
    }

    @Config(value="protocol.spooling.direct-storage-fallback")
    @ConfigDescription(value="Fallback segment retrieval through the coordinator when direct storage access is not possible")
    public SpoolingConfig setDirectStorageFallback(boolean directStorageFallback) {
        this.directStorageFallback = directStorageFallback;
        return this;
    }

    public DataSize getInitialSegmentSize() {
        return this.initialSegmentSize;
    }

    @Config(value="protocol.spooling.initial-segment-size")
    @ConfigDescription(value="Initial size of the spooled segments in bytes")
    public SpoolingConfig setInitialSegmentSize(DataSize initialSegmentSize) {
        this.initialSegmentSize = initialSegmentSize;
        return this;
    }

    public DataSize getMaximumSegmentSize() {
        return this.maximumSegmentSize;
    }

    @Config(value="protocol.spooling.maximum-segment-size")
    @ConfigDescription(value="Maximum size of the spooled segments in bytes")
    public SpoolingConfig setMaximumSegmentSize(DataSize maximumSegmentSize) {
        this.maximumSegmentSize = maximumSegmentSize;
        return this;
    }

    public boolean isInlineSegments() {
        return this.inlineSegments;
    }

    @ConfigDescription(value="Allow protocol to inline data")
    @Config(value="protocol.spooling.inline-segments")
    public SpoolingConfig setInlineSegments(boolean inlineSegments) {
        this.inlineSegments = inlineSegments;
        return this;
    }

    public Optional<SecretKey> getSharedEncryptionKey() {
        return this.sharedEncryptionKey;
    }

    @ConfigDescription(value="256 bit, base64-encoded secret key used to secure segment identifiers")
    @Config(value="protocol.spooling.shared-secret-key")
    @ConfigSecuritySensitive
    public SpoolingConfig setSharedEncryptionKey(String sharedEncryptionKey) {
        this.sharedEncryptionKey = Optional.ofNullable(sharedEncryptionKey).map(value -> new SecretKeySpec(Base64.getDecoder().decode((String)value), "AES"));
        return this;
    }

    @AssertTrue(message="protocol.spooling.shared-secret-key must be 256 bits long")
    public @AssertTrue(message="protocol.spooling.shared-secret-key must be 256 bits long") boolean isSharedEncryptionKeyAes256() {
        return this.sharedEncryptionKey.map(Ciphers::is256BitSecretKeySpec).orElse(true);
    }

    @AssertTrue(message="protocol.spooling.shared-secret-key must be set")
    public @AssertTrue(message="protocol.spooling.shared-secret-key must be set") boolean isSharedEncryptionKeySet() {
        return this.sharedEncryptionKey.isPresent();
    }
}

