/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.trino.server.ServerConfig;
import io.trino.server.protocol.spooling.PreferredQueryDataEncoderSelector;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.QueryDataJacksonModule;
import io.trino.server.protocol.spooling.SegmentResource;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.server.protocol.spooling.SpoolingEnabledConfig;
import io.trino.server.protocol.spooling.SpoolingManagerBridge;
import io.trino.server.protocol.spooling.SpoolingManagerRegistry;
import io.trino.server.protocol.spooling.encoding.QueryDataEncodingModule;
import io.trino.spi.protocol.SpoolingManager;
import java.util.Objects;

public class SpoolingServerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new QueryDataEncodingModule());
        binder.bind(SpoolingManagerRegistry.class).in(Scopes.SINGLETON);
        OptionalBinder spoolingManagerBinder = OptionalBinder.newOptionalBinder((Binder)binder, (TypeLiteral)new TypeLiteral<SpoolingManager>(this){});
        SpoolingEnabledConfig spoolingEnabledConfig = (SpoolingEnabledConfig)this.buildConfigObject(SpoolingEnabledConfig.class);
        if (!spoolingEnabledConfig.isEnabled()) {
            binder.bind(QueryDataEncoder.EncoderSelector.class).toInstance((Object)QueryDataEncoder.EncoderSelector.noEncoder());
            return;
        }
        boolean isCoordinator = ((ServerConfig)this.buildConfigObject(ServerConfig.class)).isCoordinator();
        SpoolingConfig spoolingConfig = (SpoolingConfig)this.buildConfigObject(SpoolingConfig.class);
        binder.bind(QueryDataEncoder.EncoderSelector.class).to(PreferredQueryDataEncoderSelector.class).in(Scopes.SINGLETON);
        if (spoolingConfig.isUseWorkers() || isCoordinator) {
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(SegmentResource.class);
        }
        spoolingManagerBinder.setBinding().toProvider(SpoolingManagerProvider.class).in(Scopes.SINGLETON);
    }

    @ProvidesIntoSet
    @Singleton
    public static com.fasterxml.jackson.databind.Module queryDataJacksonModule() {
        return new QueryDataJacksonModule();
    }

    private static class SpoolingManagerProvider
    implements Provider<SpoolingManager> {
        private final SpoolingManagerRegistry registry;
        private final SpoolingConfig config;

        @Inject
        public SpoolingManagerProvider(SpoolingManagerRegistry registry, SpoolingConfig config) {
            this.registry = Objects.requireNonNull(registry, "registry is null");
            this.config = Objects.requireNonNull(config, "config is null");
        }

        public SpoolingManager get() {
            return new SpoolingManagerBridge(this.config, this.registry);
        }
    }
}

