/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.log.Logger;
import io.trino.server.security.HeaderAuthenticatorConfig;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.security.HeaderAuthenticator;
import io.trino.spi.security.HeaderAuthenticatorFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class HeaderAuthenticatorManager {
    private static final Logger log = Logger.get(HeaderAuthenticatorManager.class);
    private static final String NAME_PROPERTY = "header-authenticator.name";
    private final List<File> configFiles;
    private final AtomicBoolean required = new AtomicBoolean();
    private final Map<String, HeaderAuthenticatorFactory> factories = new ConcurrentHashMap<String, HeaderAuthenticatorFactory>();
    private final AtomicReference<List<HeaderAuthenticator>> authenticators = new AtomicReference();
    private final SecretsResolver secretsResolver;

    @Inject
    public HeaderAuthenticatorManager(HeaderAuthenticatorConfig config, SecretsResolver secretsResolver) {
        this.configFiles = ImmutableList.copyOf(config.getHeaderAuthenticatorFiles());
        Preconditions.checkArgument((!this.configFiles.isEmpty() ? 1 : 0) != 0, (Object)"header authenticator files list is empty");
        this.secretsResolver = Objects.requireNonNull(secretsResolver, "secretsResolver is null");
    }

    public List<HeaderAuthenticator> getAuthenticators() {
        Preconditions.checkState((boolean)this.isLoaded(), (Object)"authenticators were not loaded");
        return this.authenticators.get();
    }

    public void addHeaderAuthenticatorFactory(HeaderAuthenticatorFactory factory) {
        Preconditions.checkArgument((this.factories.putIfAbsent(factory.getName(), factory) == null ? 1 : 0) != 0, (String)"Header authenticator '%s' is already registered", (Object)factory.getName());
    }

    public void loadHeaderAuthenticator() {
        if (!this.required.get()) {
            return;
        }
        ImmutableList.Builder authenticators = ImmutableList.builder();
        for (File configFile : this.configFiles) {
            authenticators.add((Object)this.loadAuthenticator(configFile.getAbsoluteFile()));
        }
        this.authenticators.set((List<HeaderAuthenticator>)authenticators.build());
    }

    private HeaderAuthenticator loadAuthenticator(File configFile) {
        HeaderAuthenticator authenticator;
        HashMap properties;
        try {
            properties = new HashMap(this.secretsResolver.getResolvedConfiguration(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath())));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Header authenticator configuration %s does not contain '%s'", (Object)configFile, (Object)NAME_PROPERTY);
        log.info("-- Loading header authenticator --");
        HeaderAuthenticatorFactory factory = this.factories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Header authenticator '%s' is not registered", (Object)name);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            authenticator = factory.create((Map)ImmutableMap.copyOf(properties));
        }
        log.info("-- Loaded header authenticator %s --", new Object[]{name});
        return authenticator;
    }

    public void setRequired() {
        this.required.set(true);
    }

    public boolean isLoaded() {
        return this.authenticators.get() != null;
    }
}

