/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import com.nimbusds.jose.KeyLengthException;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.client.NodeVersion;
import io.trino.server.security.oauth2.ForRefreshTokens;
import io.trino.server.security.oauth2.JweTokenSerializer;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.RefreshTokensConfig;
import io.trino.server.security.oauth2.TokenPairSerializer;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Duration;

public class JweTokenSerializerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(RefreshTokensConfig.class);
        RefreshTokensConfig config = (RefreshTokensConfig)this.buildConfigObject(RefreshTokensConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Duration.class, ForRefreshTokens.class)).setBinding().toInstance((Object)Duration.ofMillis(config.getTokenExpiration().toMillis()));
    }

    @Provides
    @Singleton
    @Inject
    public TokenPairSerializer getTokenPairSerializer(OAuth2Client client, NodeVersion nodeVersion, RefreshTokensConfig config, OAuth2Config oAuth2Config) throws KeyLengthException, NoSuchAlgorithmException {
        return new JweTokenSerializer(config, client, config.getIssuer() + "_" + nodeVersion.getVersion(), config.getAudience(), oAuth2Config.getPrincipalField(), Clock.systemUTC(), config.getTokenExpiration());
    }
}

