/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.server.ExternalUriInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.NonceCookie;
import io.trino.server.security.oauth2.OAuth2Service;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@Path(value="/oauth2/callback")
public class OAuth2CallbackResource {
    private static final Logger LOG = Logger.get(OAuth2CallbackResource.class);
    public static final String CALLBACK_ENDPOINT = "/oauth2/callback";
    private final OAuth2Service service;

    @Inject
    public OAuth2CallbackResource(OAuth2Service service) {
        this.service = Objects.requireNonNull(service, "service is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"text/html"})
    public Response callback(@QueryParam(value="state") String state, @QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription, @QueryParam(value="error_uri") String errorUri, @CookieParam(value="__Secure-Trino-Nonce") Cookie nonce, @BeanParam ExternalUriInfo externalUriInfo) {
        if (error != null) {
            return this.service.handleOAuth2Error(state, URLEncoder.encode(error, StandardCharsets.UTF_8), errorDescription, errorUri);
        }
        try {
            Objects.requireNonNull(state, "state is null");
            Objects.requireNonNull(code, "code is null");
            return this.service.finishOAuth2Challenge(state, code, externalUriInfo, NonceCookie.read(nonce));
        }
        catch (RuntimeException e) {
            LOG.debug((Throwable)e, "Authentication response could not be verified: state=%s", new Object[]{state});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cookie(new NewCookie[]{NonceCookie.delete()}).entity((Object)this.service.getInternalFailureHtml("Authentication response could not be verified")).build();
        }
    }
}

