/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlPath;
import io.trino.sql.SqlPathElement;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.tree.Identifier;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;

public class SqlEnvironmentConfig {
    private String path = "";
    private Optional<String> defaultCatalog = Optional.empty();
    private Optional<String> defaultSchema = Optional.empty();
    private Optional<String> defaultFunctionCatalog = Optional.empty();
    private Optional<String> defaultFunctionSchema = Optional.empty();
    private Optional<TimeZoneKey> forcedSessionTimeZone = Optional.empty();

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Config(value="sql.path")
    public SqlEnvironmentConfig setPath(String path) {
        this.path = path;
        return this;
    }

    @NotNull
    public Optional<String> getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Config(value="sql.default-catalog")
    public SqlEnvironmentConfig setDefaultCatalog(String catalog) {
        this.defaultCatalog = Optional.ofNullable(catalog);
        return this;
    }

    @NotNull
    public Optional<String> getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="sql.default-schema")
    public SqlEnvironmentConfig setDefaultSchema(String schema) {
        this.defaultSchema = Optional.ofNullable(schema);
        return this;
    }

    @NotNull
    public Optional<String> getDefaultFunctionCatalog() {
        return this.defaultFunctionCatalog;
    }

    @Config(value="sql.default-function-catalog")
    public SqlEnvironmentConfig setDefaultFunctionCatalog(String catalog) {
        this.defaultFunctionCatalog = Optional.ofNullable(catalog);
        return this;
    }

    @NotNull
    public Optional<String> getDefaultFunctionSchema() {
        return this.defaultFunctionSchema;
    }

    @Config(value="sql.default-function-schema")
    public SqlEnvironmentConfig setDefaultFunctionSchema(String schema) {
        this.defaultFunctionSchema = Optional.ofNullable(schema);
        return this;
    }

    @NotNull
    public Optional<TimeZoneKey> getForcedSessionTimeZone() {
        return this.forcedSessionTimeZone;
    }

    @Config(value="sql.forced-session-time-zone")
    @ConfigDescription(value="User session time zone overriding value sent by client")
    public SqlEnvironmentConfig setForcedSessionTimeZone(@Nullable String timeZoneId) {
        this.forcedSessionTimeZone = Optional.ofNullable(timeZoneId).map(TimeZoneKey::getTimeZoneKey);
        return this;
    }

    @AssertTrue(message="sql.path must be a valid SQL path")
    public @AssertTrue(message="sql.path must be a valid SQL path") boolean isSqlPathValid() {
        return this.path.isEmpty() || this.validParsedSqlPath().isPresent();
    }

    @AssertTrue(message="sql.default-function-catalog and sql.default-function-schema must be set together")
    public @AssertTrue(message="sql.default-function-catalog and sql.default-function-schema must be set together") boolean isBothFunctionCatalogAndSchemaSet() {
        return this.defaultFunctionCatalog.isPresent() == this.defaultFunctionSchema.isPresent();
    }

    @AssertTrue(message="default function schema must be in the default SQL path")
    public @AssertTrue(message="default function schema must be in the default SQL path") boolean isFunctionSchemaInSqlPath() {
        if (this.defaultFunctionCatalog.isEmpty() || this.defaultFunctionSchema.isEmpty()) {
            return true;
        }
        SqlPathElement function = new SqlPathElement(this.defaultFunctionCatalog.map(Identifier::new), this.defaultFunctionSchema.map(Identifier::new).orElseThrow());
        return this.validParsedSqlPath().map(path -> path.contains(function)).orElse(false);
    }

    private Optional<List<SqlPathElement>> validParsedSqlPath() {
        try {
            return Optional.of(SqlPath.parsePath(this.path));
        }
        catch (ParsingException e) {
            return Optional.empty();
        }
    }
}

