/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import io.trino.Session;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnalyzerFactory {
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private final StatementRewrite statementRewrite;
    private final Tracer tracer;

    @Inject
    public AnalyzerFactory(StatementAnalyzerFactory statementAnalyzerFactory, StatementRewrite statementRewrite, Tracer tracer) {
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.statementRewrite = Objects.requireNonNull(statementRewrite, "statementRewrite is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    public Analyzer createAnalyzer(Session session, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return new Analyzer(session, this, this.statementAnalyzerFactory, parameters, parameterLookup, warningCollector, planOptimizersStatsCollector, this.tracer, this.statementRewrite);
    }
}

