/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public final class LambdaMetafactoryGenerator {
    private static final Method METAFACTORY;

    private LambdaMetafactoryGenerator() {
    }

    public static <T> BytecodeExpression generateMetafactory(Class<T> interfaceType, MethodDefinition targetMethod, List<BytecodeExpression> additionalArguments) {
        Method interfaceMethod = LambdaMetafactoryGenerator.getSingleAbstractMethod(interfaceType);
        ArrayList expectedTypes = new ArrayList();
        if (targetMethod.getAccess().contains(Access.STATIC)) {
            additionalArguments.forEach(argument -> expectedTypes.add(argument.getType()));
        } else {
            Preconditions.checkArgument((!additionalArguments.isEmpty() && additionalArguments.get(0).getType().equals((Object)targetMethod.getDeclaringClass().getType()) ? 1 : 0) != 0, (Object)"Expected first additional argument to be 'this' for non-static method");
            additionalArguments.subList(1, additionalArguments.size()).forEach(argument -> expectedTypes.add(argument.getType()));
        }
        Arrays.stream(interfaceMethod.getParameterTypes()).forEach(type -> expectedTypes.add(ParameterizedType.type((Class)type)));
        Preconditions.checkArgument((boolean)expectedTypes.equals(targetMethod.getParameterTypes()), (String)"Expected target method to have parameter types %s, but has %s", expectedTypes, (Object)targetMethod.getParameterTypes());
        Type interfaceMethodType = LambdaMetafactoryGenerator.toMethodType(interfaceMethod);
        return BytecodeExpressions.invokeDynamic((Method)METAFACTORY, (Iterable)ImmutableList.of((Object)interfaceMethodType, (Object)new Handle(targetMethod.getAccess().contains(Access.STATIC) ? 6 : 5, targetMethod.getDeclaringClass().getName(), targetMethod.getName(), targetMethod.getMethodDescriptor(), false), (Object)interfaceMethodType), (String)"build", (ParameterizedType)ParameterizedType.type(interfaceType), additionalArguments);
    }

    private static Type toMethodType(Method interfaceMethod) {
        return Type.getMethodType((Type)Type.getType(interfaceMethod.getReturnType()), (Type[])((Type[])Arrays.stream(interfaceMethod.getParameterTypes()).map(Type::getType).toArray(Type[]::new)));
    }

    private static <T> Method getSingleAbstractMethod(Class<T> interfaceType) {
        List interfaceMethods = (List)Arrays.stream(interfaceType.getMethods()).filter(m -> Modifier.isAbstract(m.getModifiers())).filter(m -> Modifier.isPublic(m.getModifiers())).filter(LambdaMetafactoryGenerator::notJavaObjectMethod).collect(ImmutableList.toImmutableList());
        if (interfaceMethods.size() != 1) {
            throw new IllegalArgumentException(interfaceType.getSimpleName() + "  does not have a single abstract method");
        }
        return (Method)interfaceMethods.get(0);
    }

    private static boolean notJavaObjectMethod(Method method) {
        return !LambdaMetafactoryGenerator.methodMatches(method, "toString", String.class, new Class[0]) && !LambdaMetafactoryGenerator.methodMatches(method, "hashCode", Integer.TYPE, new Class[0]) && !LambdaMetafactoryGenerator.methodMatches(method, "equals", Boolean.TYPE, Object.class);
    }

    private static boolean methodMatches(Method method, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return method.getParameterCount() == parameterTypes.length && method.getReturnType() == returnType && name.equals(method.getName()) && Arrays.equals(method.getParameterTypes(), parameterTypes);
    }

    static {
        try {
            METAFACTORY = LambdaMetafactory.class.getMethod("metafactory", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

