/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;

@JsonSerialize
public record FieldReference(Expression base, int field) implements Expression
{
    public FieldReference {
        Type type = base.type();
        if (!(type instanceof RowType)) {
            throw new IllegalArgumentException("Expected 'row' type but found '%s' for expression: %s".formatted(base.type(), base));
        }
        RowType rowType = (RowType)type;
        Preconditions.checkArgument((field < rowType.getFields().size() ? 1 : 0) != 0, (String)"Expected 'row' type to have at least %s fields, but has: %s", (int)(field + 1), (int)rowType.getFields().size());
    }

    @Override
    public Type type() {
        return ((RowType.Field)((RowType)this.base.type()).getFields().get(this.field)).getType();
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitFieldReference(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of((Object)this.base);
    }
}

