/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.TrinoException;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.optimizer.IrExpressionEvaluator;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import java.util.Map;
import java.util.Optional;

public class EvaluateCall
implements IrOptimizerRule {
    private static final CatalogSchemaFunctionName FAIL_NAME = GlobalFunctionCatalog.builtinFunctionName("fail");
    private final IrExpressionEvaluator evaluator;

    public EvaluateCall(PlannerContext context) {
        this.evaluator = new IrExpressionEvaluator(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        ResolvedFunction function;
        Object object;
        if (!(expression instanceof Call)) return Optional.empty();
        Call call = (Call)expression;
        try {
            object = call.function();
            function = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object arguments = object = call.arguments();
        if (!arguments.stream().allMatch(argument -> argument instanceof Constant || argument instanceof Lambda && DeterminismEvaluator.isDeterministic(argument))) {
            return Optional.empty();
        }
        if (!function.deterministic()) {
            return Optional.empty();
        }
        if (DynamicFilters.isDynamicFilter(expression)) {
            return Optional.empty();
        }
        if (function.name().equals((Object)FAIL_NAME)) {
            return Optional.empty();
        }
        try {
            return Optional.of(new Constant(expression.type(), this.evaluator.evaluate(expression, session, (Map<String, Object>)ImmutableMap.of())));
        }
        catch (TrinoException trinoException) {
            return Optional.empty();
        }
    }
}

