/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.SimplePlanVisitor;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ExpressionExtractor {
    public static List<Expression> extractExpressions(PlanNode plan) {
        return ExpressionExtractor.extractExpressions(plan, Lookup.noLookup());
    }

    public static List<Expression> extractExpressions(PlanNode plan, Lookup lookup) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(lookup, "lookup is null");
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(arg_0 -> ((ImmutableList.Builder)expressionsBuilder).add(arg_0), true, lookup), null);
        return expressionsBuilder.build();
    }

    public static List<Expression> extractExpressionsNonRecursive(PlanNode plan) {
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(arg_0 -> ((ImmutableList.Builder)expressionsBuilder).add(arg_0), false, Lookup.noLookup()), null);
        return expressionsBuilder.build();
    }

    public static void forEachExpression(PlanNode plan, Consumer<Expression> expressionConsumer) {
        plan.accept(new Visitor(expressionConsumer, true, Lookup.noLookup()), null);
    }

    private ExpressionExtractor() {
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Consumer<Expression> consumer;
        private final boolean recursive;
        private final Lookup lookup;

        Visitor(Consumer<Expression> consumer, boolean recursive, Lookup lookup) {
            this.consumer = Objects.requireNonNull(consumer, "consumer is null");
            this.recursive = recursive;
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            if (this.recursive) {
                return super.visitPlan(node, context);
            }
            return null;
        }

        @Override
        public Void visitGroupReference(GroupReference node, Void context) {
            return this.lookup.resolve(node).accept(this, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                aggregation.getArguments().forEach(this.consumer);
            }
            return (Void)super.visitAggregation(node, context);
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            this.consumer.accept(node.getPredicate());
            return (Void)super.visitFilter(node, context);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            node.getAssignments().getExpressions().forEach(this.consumer);
            return (Void)super.visitProject(node, context);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getFilter().ifPresent(this.consumer);
            return (Void)super.visitJoin(node, context);
        }

        @Override
        public Void visitValues(ValuesNode node, Void context) {
            node.getRows().ifPresent(list -> list.forEach(this.consumer));
            return (Void)super.visitValues(node, context);
        }
    }
}

