/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.BuildSideJoinPlanVisitor;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class SchedulingOrderVisitor {
    public static List<PlanNodeId> scheduleOrder(PlanNode root) {
        ImmutableList.Builder schedulingOrder = ImmutableList.builder();
        root.accept(new Visitor(arg_0 -> ((ImmutableList.Builder)schedulingOrder).add(arg_0)), null);
        return schedulingOrder.build();
    }

    private SchedulingOrderVisitor() {
    }

    private static class Visitor
    extends BuildSideJoinPlanVisitor<Void> {
        private final Consumer<PlanNodeId> schedulingOrder;

        public Visitor(Consumer<PlanNodeId> schedulingOrder) {
            this.schedulingOrder = Objects.requireNonNull(schedulingOrder, "schedulingOrder is null");
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            this.schedulingOrder.accept(node.getId());
            return null;
        }

        @Override
        public Void visitTableFunctionProcessor(TableFunctionProcessorNode node, Void context) {
            if (node.getSource().isEmpty()) {
                this.schedulingOrder.accept(node.getId());
            } else {
                node.getSource().orElseThrow().accept(this, context);
            }
            return null;
        }
    }
}

