/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.matching.PropertyPattern;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.WindowNodeUtil;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class GatherAndMergeWindows {
    private GatherAndMergeWindows() {
    }

    public static Set<Rule<?>> rules() {
        return (Set)IntStream.range(0, 5).boxed().flatMap(numProjects -> Stream.of(new MergeAdjacentWindowsOverProjects((int)numProjects), new SwapAdjacentWindowsBySpecifications((int)numProjects))).collect(ImmutableSet.toImmutableSet());
    }

    private static abstract class ManipulateAdjacentWindowsOverProjects
    implements Rule<WindowNode> {
        private final Capture<WindowNode> childCapture = Capture.newCapture();
        private final List<Capture<ProjectNode>> projectCaptures;
        private final Pattern<WindowNode> pattern;

        protected ManipulateAdjacentWindowsOverProjects(int numProjects) {
            PropertyPattern childPattern = Patterns.source().matching(Patterns.window().capturedAs(this.childCapture));
            ImmutableList.Builder projectCapturesBuilder = ImmutableList.builder();
            for (int i = 0; i < numProjects; ++i) {
                Capture projectCapture = Capture.newCapture();
                projectCapturesBuilder.add((Object)projectCapture);
                childPattern = Patterns.source().matching(Patterns.project().capturedAs(projectCapture).with(childPattern));
            }
            this.projectCaptures = projectCapturesBuilder.build();
            this.pattern = Patterns.window().with(childPattern);
        }

        @Override
        public Pattern<WindowNode> getPattern() {
            return this.pattern;
        }

        @Override
        public Rule.Result apply(WindowNode parent, Captures captures, Rule.Context context) {
            List projects = (List)this.projectCaptures.stream().map(arg_0 -> ((Captures)captures).get(arg_0)).collect(ImmutableList.toImmutableList());
            return ManipulateAdjacentWindowsOverProjects.pullWindowNodeAboveProjects((WindowNode)captures.get(this.childCapture), projects).flatMap(newChild -> this.manipulateAdjacentWindowNodes(parent, (WindowNode)newChild, context)).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
        }

        protected abstract Optional<PlanNode> manipulateAdjacentWindowNodes(WindowNode var1, WindowNode var2, Rule.Context var3);

        protected static Optional<WindowNode> pullWindowNodeAboveProjects(WindowNode target, List<ProjectNode> projects) {
            if (projects.isEmpty()) {
                return Optional.of(target);
            }
            PlanNode targetChild = target.getSource();
            ImmutableSet targetInputs = ImmutableSet.copyOf(targetChild.getOutputSymbols());
            ImmutableSet targetOutputs = ImmutableSet.copyOf(target.getOutputSymbols());
            PlanNode newTargetChild = targetChild;
            for (ProjectNode project : projects) {
                ImmutableSet newTargetChildOutputs = ImmutableSet.copyOf(newTargetChild.getOutputSymbols());
                Map assignmentsWithoutTargetOutputIdentities = Maps.filterKeys(project.getAssignments().getMap(), arg_0 -> ManipulateAdjacentWindowsOverProjects.lambda$pullWindowNodeAboveProjects$1(project, (Set)targetOutputs, arg_0));
                if (targetInputs.stream().anyMatch(assignmentsWithoutTargetOutputIdentities::containsKey)) {
                    return Optional.empty();
                }
                Assignments newAssignments = Assignments.builder().putAll(assignmentsWithoutTargetOutputIdentities).putIdentities((Iterable<Symbol>)targetInputs).build();
                if (!newTargetChildOutputs.containsAll(SymbolsExtractor.extractUnique(newAssignments.getExpressions()))) {
                    return Optional.empty();
                }
                newTargetChild = new ProjectNode(project.getId(), newTargetChild, newAssignments);
            }
            WindowNode newTarget = (WindowNode)target.replaceChildren((List<PlanNode>)ImmutableList.of((Object)newTargetChild));
            ImmutableSet newTargetOutputs = ImmutableSet.copyOf(newTarget.getOutputSymbols());
            if (!newTargetOutputs.containsAll(projects.getLast().getOutputSymbols())) {
                return Optional.empty();
            }
            return Optional.of(newTarget);
        }

        private static /* synthetic */ boolean lambda$pullWindowNodeAboveProjects$1(ProjectNode project, Set targetOutputs, Symbol output) {
            return !project.getAssignments().isIdentity(output) || !targetOutputs.contains(output);
        }
    }

    public static class MergeAdjacentWindowsOverProjects
    extends ManipulateAdjacentWindowsOverProjects {
        public MergeAdjacentWindowsOverProjects(int numProjects) {
            super(numProjects);
        }

        @Override
        protected Optional<PlanNode> manipulateAdjacentWindowNodes(WindowNode parent, WindowNode child, Rule.Context context) {
            if (!child.getSpecification().equals(parent.getSpecification()) || WindowNodeUtil.dependsOn(parent, child)) {
                return Optional.empty();
            }
            ImmutableMap.Builder functionsBuilder = ImmutableMap.builder();
            functionsBuilder.putAll(parent.getWindowFunctions());
            functionsBuilder.putAll(child.getWindowFunctions());
            WindowNode mergedWindowNode = new WindowNode(parent.getId(), child.getSource(), parent.getSpecification(), (Map<Symbol, WindowNode.Function>)functionsBuilder.buildOrThrow(), parent.getHashSymbol(), parent.getPrePartitionedInputs(), parent.getPreSortedOrderPrefix());
            return Optional.of(Util.restrictOutputs(context.getIdAllocator(), mergedWindowNode, (Set<Symbol>)ImmutableSet.copyOf(parent.getOutputSymbols())).orElse(mergedWindowNode));
        }
    }

    public static class SwapAdjacentWindowsBySpecifications
    extends ManipulateAdjacentWindowsOverProjects {
        public SwapAdjacentWindowsBySpecifications(int numProjects) {
            super(numProjects);
        }

        @Override
        protected Optional<PlanNode> manipulateAdjacentWindowNodes(WindowNode parent, WindowNode child, Rule.Context context) {
            if (SwapAdjacentWindowsBySpecifications.compare(parent, child) < 0 && !WindowNodeUtil.dependsOn(parent, child)) {
                PlanNode transposedWindows = Util.transpose(parent, child);
                return Optional.of(Util.restrictOutputs(context.getIdAllocator(), transposedWindows, (Set<Symbol>)ImmutableSet.copyOf(parent.getOutputSymbols())).orElse(transposedWindows));
            }
            return Optional.empty();
        }

        private static int compare(WindowNode o1, WindowNode o2) {
            int comparison = SwapAdjacentWindowsBySpecifications.comparePartitionBy(o1, o2);
            if (comparison != 0) {
                return comparison;
            }
            comparison = SwapAdjacentWindowsBySpecifications.compareOrderBy(o1, o2);
            if (comparison != 0) {
                return comparison;
            }
            return o1.getId().toString().compareTo(o2.getId().toString());
        }

        private static int comparePartitionBy(WindowNode o1, WindowNode o2) {
            Iterator<Symbol> iterator1 = o1.getPartitionBy().iterator();
            Iterator<Symbol> iterator2 = o2.getPartitionBy().iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                Symbol symbol1 = iterator1.next();
                Symbol symbol2 = iterator2.next();
                int partitionByComparison = symbol1.name().compareTo(symbol2.name());
                if (partitionByComparison == 0) continue;
                return partitionByComparison;
            }
            if (iterator1.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        }

        private static int compareOrderBy(WindowNode o1, WindowNode o2) {
            if (o1.getOrderingScheme().isEmpty() && o2.getOrderingScheme().isEmpty()) {
                return 0;
            }
            if (o1.getOrderingScheme().isPresent() && o2.getOrderingScheme().isEmpty()) {
                return 1;
            }
            if (o1.getOrderingScheme().isEmpty() && o2.getOrderingScheme().isPresent()) {
                return -1;
            }
            OrderingScheme o1OrderingScheme = o1.getOrderingScheme().get();
            OrderingScheme o2OrderingScheme = o2.getOrderingScheme().get();
            Iterator<Symbol> iterator1 = o1OrderingScheme.orderBy().iterator();
            Iterator<Symbol> iterator2 = o2OrderingScheme.orderBy().iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                Symbol symbol1 = iterator1.next();
                Symbol symbol2 = iterator2.next();
                int orderByComparison = symbol1.name().compareTo(symbol2.name());
                if (orderByComparison != 0) {
                    return orderByComparison;
                }
                int sortOrderComparison = o1OrderingScheme.ordering(symbol1).compareTo((Enum)o2OrderingScheme.ordering(symbol2));
                if (sortOrderComparison == 0) continue;
                return sortOrderComparison;
            }
            if (iterator1.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        }
    }
}

