/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Logical;
import java.util.List;

public final class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        @Override
        public Expression rewriteCall(Call node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("$not"))) {
                Record child;
                ResolvedFunction function = node.function();
                Expression argument = node.arguments().getFirst();
                if (argument instanceof Logical) {
                    Logical child2 = (Logical)argument;
                    List<Expression> predicates = IrUtils.extractPredicates(child2);
                    List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite(new Call(function, (List<Expression>)ImmutableList.of((Object)predicate)), context)).collect(ImmutableList.toImmutableList());
                    return IrUtils.combinePredicates(child2.operator().flip(), negatedPredicates);
                }
                if (argument instanceof Comparison && ((Comparison)(child = (Comparison)argument)).operator() != Comparison.Operator.IDENTICAL) {
                    Comparison.Operator operator = ((Comparison)child).operator();
                    Expression left = ((Comparison)child).left();
                    Expression right = ((Comparison)child).right();
                    Type leftType = left.type();
                    Type rightType = right.type();
                    if ((this.typeHasNaN(leftType) || this.typeHasNaN(rightType)) && (operator == Comparison.Operator.GREATER_THAN_OR_EQUAL || operator == Comparison.Operator.GREATER_THAN || operator == Comparison.Operator.LESS_THAN_OR_EQUAL || operator == Comparison.Operator.LESS_THAN)) {
                        return new Call(function, (List<Expression>)ImmutableList.of((Object)new Comparison(operator, treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context))));
                    }
                    return new Comparison(operator.negate(), treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context));
                }
                if (argument instanceof Call && ((Call)(child = (Call)argument)).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("$not"))) {
                    return treeRewriter.rewrite(((Call)child).arguments().getFirst(), context);
                }
                return new Call(function, (List<Expression>)ImmutableList.of((Object)treeRewriter.rewrite(argument, context)));
            }
            return node;
        }

        private boolean typeHasNaN(Type type) {
            return type instanceof DoubleType || type instanceof RealType;
        }
    }
}

