/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;

@Immutable
public class EnforceSingleRowNode
extends PlanNode {
    private final PlanNode source;

    @JsonCreator
    public EnforceSingleRowNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitEnforceSingleRow(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new EnforceSingleRowNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren));
    }
}

