/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.TableExecuteHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;

public class SimpleTableExecuteNode
extends PlanNode {
    private final Symbol output;
    private final TableExecuteHandle executeHandle;

    @JsonCreator
    public SimpleTableExecuteNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="output") Symbol output, @JsonProperty(value="executeHandle") TableExecuteHandle executeHandle) {
        super(id);
        this.output = Objects.requireNonNull(output, "output is null");
        this.executeHandle = Objects.requireNonNull(executeHandle, "executeHandle is null");
    }

    @Override
    @JsonProperty
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.output);
    }

    @JsonProperty
    public Symbol getOutput() {
        return this.output;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren should be empty");
        return this;
    }

    @JsonProperty
    public TableExecuteHandle getExecuteHandle() {
        return this.executeHandle;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleTableExecuteNode(this, context);
    }
}

