/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;

public final class VerifyOnlyOneOutputNode
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        int outputPlanNodesCount = PlanNodeSearcher.searchFrom(plan).where(OutputNode.class::isInstance).findAll().size();
        Preconditions.checkState((outputPlanNodesCount == 1 ? 1 : 0) != 0, (Object)"Expected plan to have single instance of OutputNode");
    }
}

